/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.addonslib.api.data.BlockId;
import fr.addonslib.api.data.McwBlockIdBase;
import fr.addonslib.api.data.McwBlocksIdBase;
import fr.addonslib.api.data.ModType;
import fr.addonslib.api.recipes.CraftingIngredient;
import fr.addonslib.api.recipes.RecipesBase;
import fr.addonslib.api.recipes.material.McwStoneMat;
import fr.addonslib.api.recipes.material.McwWoodMat;
import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public abstract class McwRecipes
extends RecipeProvider {
    public McwRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> p_333797_) {
        super(p_248933_, p_333797_);
    }

    private void makeRecipesWood(McwBlockIdBase mcwBlockIdBase, RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<Block>> woodMats) {
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < woodMats.size(); ++i) {
                    String mat = MAT.get(i);
                    McwWoodMat<Block> woodMat = woodMats.get(i);
                    Block result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1ItemRecycle": {
                                this.recipeShapelessWith1ItemRecycle(output, (ItemLike)woodMat.getLog(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1Item": {
                                this.recipeShapelessWith1Item(output, (ItemLike)woodMat.getLog(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith2Items": {
                                this.recipeShapedWith2Items(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith3Items": {
                                this.recipeShapedWith3Items(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[2]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith4Items": {
                                this.recipeShapedWith4Items(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[2]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[3]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    private void makeRecipesStone(McwBlockIdBase mcwBlockIdBase, RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<Block>> stoneMats) {
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < stoneMats.size(); ++i) {
                    String mat = MAT.get(i);
                    McwStoneMat<Block> stoneMat = stoneMats.get(i);
                    Block result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1ItemRecycle": {
                                this.recipeShapelessWith1ItemRecycle(output, (ItemLike)stoneMat.getStoneBase(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1Item": {
                                this.recipeShapelessWith1Item(output, (ItemLike)stoneMat.getStoneBase(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith2Items": {
                                this.recipeShapedWith2Items(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith3Items": {
                                this.recipeShapedWith3Items(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[2]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith4Items": {
                                this.recipeShapedWith4Items(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[2]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[3]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeStonecutter": {
                                this.recipeStonecutter(output, (ItemLike)result, (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    private Item replaceTypeWood(String MODID, String mat, McwWoodMat<Block> woodMat, CraftingIngredient type) {
        switch (type.getName()) {
            case "stripped_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_table");
            }
            case "table": {
                return Finder.findItem(MODID, mat + "_table");
            }
            case "log_bridge": {
                return Finder.findItem(MODID, mat + "_log_bridge_middle");
            }
            case "log_bridge_stair": {
                return Finder.findItem(MODID, mat + "_log_bridge_stair");
            }
            case "wardrobe": {
                return Finder.findItem(MODID, mat + "_wardrobe");
            }
            case "stripped_wardrobe": {
                return Finder.findItem(MODID, "stripped_" + mat + "_wardrobe");
            }
            case "coffee_table": {
                return Finder.findItem(MODID, mat + "_coffee_table");
            }
            case "stripped_coffee_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_coffee_table");
            }
            case "stable_door": {
                return Finder.findItem(MODID, mat + "_stable_door");
            }
            case "rope_bridge": {
                return Finder.findItem(MODID, "rope_" + mat + "_bridge");
            }
            case "balcony": {
                return Finder.findItem(MODID, mat + "_balcony");
            }
            case "drawer": {
                return Finder.findItem(MODID, mat + "_drawer");
            }
            case "stripped_drawer": {
                return Finder.findItem(MODID, "stripped_" + mat + "_drawer");
            }
            case "double_drawer": {
                return Finder.findItem(MODID, mat + "_double_drawer");
            }
            case "stripped_double_drawer": {
                return Finder.findItem(MODID, "stripped_" + mat + "_double_drawer");
            }
            case "stripped_end_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_end_table");
            }
            case "end_table": {
                return Finder.findItem(MODID, mat + "_end_table");
            }
            case "rope_bridge_stair": {
                return Finder.findItem(MODID, mat + "_rope_bridge_stair");
            }
            case "glass_trapdoor": {
                return Finder.findItem(MODID, mat + "_glass_trapdoor");
            }
            case "mcwfurnitures:cabinet_door": {
                return Finder.findItem("mcwfurnitures:cabinet_door");
            }
            case "mcwfurnitures:cabinet_drawer": {
                return Finder.findItem("mcwfurnitures:cabinet_drawer");
            }
            case "mcwwindows:window_base": {
                return Finder.findItem("mcwwindows:window_base");
            }
            case "mcwwindows:window_half_bar_base": {
                return Finder.findItem("mcwwindows:window_half_bar_base");
            }
            case "mcwwindows:window_centre_bar_base": {
                return Finder.findItem("mcwwindows:window_centre_bar_base");
            }
            case "minecraft:stick": {
                return Items.STICK;
            }
            case "minecraft:iron_bars": {
                return Items.IRON_BARS;
            }
            case "minecraft:cauldron": {
                return Items.CAULDRON;
            }
            case "minecraft:water_bucket": {
                return Items.WATER_BUCKET;
            }
            case "minecraft:barrel": {
                return Items.BARREL;
            }
            case "minecraft:paper": {
                return Items.PAPER;
            }
            case "minecraft:glass_pane": {
                return Items.GLASS_PANE;
            }
            case "minecraft:glass": {
                return Items.GLASS;
            }
            case "minecraft:string": {
                return Items.STRING;
            }
            case "minecraft:book": {
                return Items.BOOK;
            }
            case "log": {
                return woodMat.getLog().asItem();
            }
            case "planks": {
                return woodMat.getPlanks().asItem();
            }
            case "strippedLog": {
                return woodMat.getStrippedLog().asItem();
            }
            case "slab": {
                return woodMat.getSlab().asItem();
            }
            case "fence": {
                return woodMat.getFence().asItem();
            }
            case "trapdoor": {
                return woodMat.getTrapdoor().asItem();
            }
        }
        return Finder.findItem(type.getName());
    }

    private Item replaceTypeStone(String MODID, String mat, McwStoneMat<Block> woodMat, CraftingIngredient type) {
        switch (type.getName()) {
            case "stone_bridge": {
                return Finder.findItem(MODID, mat + "_bridge");
            }
            case "stone_bridge_stair": {
                return Finder.findItem(MODID, mat + "_bridge_stair");
            }
            case "minecraft:dirt": {
                return Items.DIRT;
            }
            case "minecraft:iron_bars": {
                return Items.IRON_BARS;
            }
            case "minecraft:glass_pane": {
                return Items.GLASS_PANE;
            }
            case "minecraft:glass": {
                return Items.GLASS;
            }
            case "stoneBase": {
                return woodMat.getStoneBase().asItem();
            }
            case "stoneSlab": {
                return woodMat.getSlab().asItem();
            }
            case "stoneWall": {
                return woodMat.getWall().asItem();
            }
            case "smoothStone": {
                return woodMat.getSmoothStone().asItem();
            }
        }
        return Items.AIR;
    }

    protected void registerMcwWood(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<Block>> woodMats, ModType ... modType) {
        for (ModType mod : modType) {
            McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidWood(mod);
            this.makeRecipesWood(mcwBlockIdBase, output, modid, originalMod, MAT, woodMats);
        }
    }

    protected void registerMcwStone(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<Block>> stoneMats, ModType ... modType) {
        for (ModType mod : modType) {
            McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidStone(mod);
            this.makeRecipesStone(mcwBlockIdBase, output, modid, originalMod, MAT, stoneMats);
        }
    }

    protected void registerMcwHedge(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<Block> blockLeave) {
        McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.FENCES_LEAVE_BLOCKS;
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < blockLeave.size(); ++i) {
                    String mat = MAT.get(i);
                    Block leave = blockLeave.get(i);
                    Block result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (ItemLike)leave, recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)leave, recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    public void registerAllMcwWood(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<Block>> woodMats) {
        this.registerMcwWood(output, modid, originalMod, MAT, woodMats, Registration.getAllModTypeWood());
    }

    public void registerAllMcwStone(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<Block>> stoneMats) {
        this.registerMcwStone(output, modid, originalMod, MAT, stoneMats, Registration.getAllModTypeStone());
    }

    protected void recipeShapelessWith1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group, String originalMod, String mcwMod) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).requires(firstItem, required).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)).save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}));
    }

    protected void recipeShapelessWith1ItemRecycle(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group, String originalMod, String mcwMod) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).requires(firstItem, required).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)).save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}), ResourceLocation.fromNamespaceAndPath((String)Finder.getModidOfItem(result.asItem()), (String)(Finder.getIdOfItem(result.asItem()) + "_recycle")));
    }

    protected void recipeShapedWith1Item(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, String group, String originalMod, String mcwMod) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : (pattern.length == 2 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}));
    }

    protected void recipeShapedWith2Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, String group, String originalMod, String mcwMod) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : (pattern.length == 2 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}));
    }

    protected void recipeShapedWith3Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, String group, String originalMod, String mcwMod) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : (pattern.length == 2 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}));
    }

    protected void recipeShapedWith4Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, ItemLike fourItem, String group, String originalMod, String mcwMod) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : (pattern.length == 2 ? ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)) : ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}));
    }

    protected void recipeStonecutter(RecipeOutput output, ItemLike result, ItemLike firstItem, String originalMod, String mcwMod) {
        String recipeId = Objects.requireNonNull(result.asItem().toString()) + "_stonecutter";
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{firstItem}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).unlockedBy(McwRecipes.getHasName((ItemLike)firstItem), McwRecipes.has((ItemLike)firstItem)).save(output.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(mcwMod), new ModLoadedCondition(originalMod)))}), recipeId);
    }
}

