/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.registry;

import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class RaidRegHelper<T extends Raider> {
    protected final String name;
    protected final Supplier<EntityType<? extends T>> entityType;
    protected final DeferredItem<DeferredSpawnEggItem> spawnEgg;
    protected DeferredHolder<SoundEvent, SoundEvent> AMBIENT;
    protected DeferredHolder<SoundEvent, SoundEvent> DEATH;
    protected DeferredHolder<SoundEvent, SoundEvent> HURT;
    protected DeferredHolder<SoundEvent, SoundEvent> CELEBRATE;
    protected DeferredHolder<SoundEvent, SoundEvent> CASTING;

    @NotNull
    public String getName() {
        return this.name;
    }

    public EntityType<? extends T> getEntityType() {
        return this.entityType.get();
    }

    public DeferredItem<DeferredSpawnEggItem> getSpawnEgg() {
        return this.spawnEgg;
    }

    public SoundEvent getAmbient() {
        return this.AMBIENT == null ? null : (SoundEvent)this.AMBIENT.get();
    }

    public SoundEvent getDeath() {
        return this.DEATH == null ? null : (SoundEvent)this.DEATH.get();
    }

    public SoundEvent getHurt() {
        return this.HURT == null ? null : (SoundEvent)this.HURT.get();
    }

    public SoundEvent getCelebrate() {
        return this.CELEBRATE == null ? null : (SoundEvent)this.CELEBRATE.get();
    }

    public SoundEvent getCasting() {
        return this.CASTING == null ? null : (SoundEvent)this.CASTING.get();
    }

    public RaidRegHelper(String name, EntityType.Builder<T> builder, int backgroundColor, int highlightColor, boolean casting) {
        this.name = name;
        this.entityType = RaidedRegistry.ENTITY_TYPES.register(name, () -> builder.build(name));
        this.spawnEgg = RaidedRegistry.ITEMS.register(name + "_spawn_egg", () -> new DeferredSpawnEggItem(this.entityType, backgroundColor, highlightColor, new Item.Properties()));
        this.AMBIENT = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".ambient", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raided", (String)("entity." + name + ".ambient"))));
        this.DEATH = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".death", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raided", (String)("entity." + name + ".death"))));
        this.HURT = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".hurt", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raided", (String)("entity." + name + ".hurt"))));
        this.CELEBRATE = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".celebrate", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raided", (String)("entity." + name + ".celebrate"))));
        if (casting) {
            this.CASTING = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".casting", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raided", (String)("entity." + name + ".casting"))));
        }
    }

    public RaidRegHelper(String name, EntityType.Builder<T> builder, int backgroundColor, int highlightColor) {
        this(name, builder, backgroundColor, highlightColor, false);
    }
}

