/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.entity.goal.WalkToRaiderGoal;
import com.mrbysco.raided.registry.RaidedRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;

public class Necromancer
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> HEALING = SynchedEntityData.defineId(Necromancer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected int healingTickCount;

    public Necromancer(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new WalkToRaiderGoal((Mob)this, 1.0, 4.0f, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEALING, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.healingTickCount = tag.getInt("HealingTicks");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("HealingTicks", this.healingTickCount);
    }

    public boolean isHealing() {
        if (this.level().isClientSide) {
            return (Boolean)this.entityData.get(HEALING);
        }
        return this.healingTickCount > 0;
    }

    public void setIsHealing(boolean value) {
        this.entityData.set(HEALING, (Object)value);
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isHealing()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean isAlliedTo(Entity entity) {
        if (super.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && entity.getTeam() == null;
        }
        return false;
    }

    public void applyRaidBuffs(ServerLevel p_348605_, int p_37844_, boolean p_37845_) {
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.healingTickCount > 0) {
            --this.healingTickCount;
        } else {
            this.setIsHealing(false);
        }
    }

    public boolean canHeal() {
        return this.healingTickCount == 0;
    }

    public void healMember(Raider raider) {
        float halfHealth = raider.getMaxHealth() / 2.0f;
        raider.heal(halfHealth);
        this.hurt(this.damageSources().magic(), (float)Math.ceil(halfHealth / 5.0f));
        this.setIsHealing(true);
        this.healingTickCount = 30;
    }

    public boolean canBeLeader() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return RaidedRegistry.NECROMANCER.getAmbient();
    }

    protected SoundEvent getDeathSound() {
        return RaidedRegistry.NECROMANCER.getDeath();
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return RaidedRegistry.NECROMANCER.getHurt();
    }

    public SoundEvent getCelebrateSound() {
        return RaidedRegistry.NECROMANCER.getCelebrate();
    }
}

