/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.entity.projectiles.IncineratorFireball;
import com.mrbysco.raided.registry.RaidedRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Incinerator
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> THROWING_DATA = SynchedEntityData.defineId(Incinerator.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> WEAPON_TYPE_DATA = SynchedEntityData.defineId(Incinerator.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean animationPlay = false;
    private int animationTimer = 0;
    private int switchHealth = 0;
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 15.0f);
    private final MeleeAttackGoal incineratorMeleeGoal = new IncineratorMeleeAttackGoal(this);

    public Incinerator(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(THROWING_DATA, (Object)false);
        builder.define(WEAPON_TYPE_DATA, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.275f).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 2.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("WeaponType", this.getWeaponType());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("WeaponType")) {
            int typeID = tag.getInt("WeaponType");
            this.setWeaponType(typeID);
        }
    }

    public int getWeaponType() {
        return (Integer)this.entityData.get(WEAPON_TYPE_DATA);
    }

    private void setWeaponType(int type) {
        this.entityData.set(WEAPON_TYPE_DATA, (Object)type);
    }

    public boolean isThrowing() {
        return (Boolean)this.entityData.get(THROWING_DATA);
    }

    private void setThrowing(boolean throwing) {
        this.entityData.set(THROWING_DATA, (Object)throwing);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - this.getX();
        double d1 = target.getBoundingBox().minY + (double)target.getBbHeight() / 2.0 - (this.getY() + (double)this.getBbHeight() / 2.0);
        double d2 = target.getZ() - this.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        for (int i = 0; i < 3; ++i) {
            Vec3 vec3 = new Vec3(this.getRandom().triangle(d1, 2.297 * f1), d2, this.getRandom().triangle(d2, 2.297 * f1));
            IncineratorFireball fireball = new IncineratorFireball(this.level(), (LivingEntity)this, vec3.normalize());
            fireball.setPos(fireball.getX(), fireball.getY() + (double)this.getBbHeight() / 2.0 + 0.5, fireball.getZ());
            this.level().addFreshEntity((Entity)fireball);
        }
        this.setThrowing(true);
        this.animationPlay = true;
        this.animationTimer = 0;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            entity.igniteForTicks(4);
        }
        return true;
    }

    public boolean isAlliedTo(Entity entity) {
        if (super.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && entity.getTeam() == null;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.hasShield()) {
            Entity entity = source.getDirectEntity();
            return !(entity instanceof Projectile) ? super.hurt(source, amount) : false;
        }
        return super.hurt(source, amount);
    }

    private boolean hasShield() {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.OFFHAND);
        return itemstack.getItem() instanceof ShieldItem;
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public void applyRaidBuffs(ServerLevel p_348605_, int p_37844_, boolean p_37845_) {
        if (this.random.nextFloat() < 0.25f) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.SHIELD));
        }
    }

    public boolean canBeLeader() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return RaidedRegistry.INCINERATOR.getAmbient();
    }

    protected SoundEvent getDeathSound() {
        return RaidedRegistry.INCINERATOR.getDeath();
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return RaidedRegistry.INCINERATOR.getHurt();
    }

    public SoundEvent getCelebrateSound() {
        return RaidedRegistry.INCINERATOR.getCelebrate();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        groupData = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, groupData);
        this.setCanPickUpLoot(this.random.nextFloat() < 0.55f * difficultyInstance.getSpecialMultiplier());
        this.setCombatGoal();
        return groupData;
    }

    private void setCombatGoal() {
        ItemStack itemstack = this.getMainHandItem();
        if (itemstack.isEmpty()) {
            this.goalSelector.removeGoal((Goal)this.incineratorMeleeGoal);
            this.goalSelector.addGoal(1, (Goal)this.rangedAttackGoal);
            this.setThrowing(false);
            this.animationPlay = false;
            this.animationTimer = 0;
        } else {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.incineratorMeleeGoal);
        }
    }

    public void tick() {
        if (this.getHealth() < this.getMaxHealth() * 0.75f && this.switchHealth == 0) {
            if (this.getWeaponType() == 0) {
                if (this.random.nextInt(4) == 0) {
                    this.setWeaponType(2);
                } else {
                    this.setWeaponType(1);
                }
            }
            this.setCombatGoal();
            this.switchHealth = 1;
        }
        if (this.getHealth() > this.getMaxHealth() * 0.75f && this.switchHealth == 1) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.setCombatGoal();
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setCombatGoal();
                this.animationPlay = false;
            }
        }
        super.tick();
    }

    static class IncineratorMeleeAttackGoal
    extends MeleeAttackGoal {
        public IncineratorMeleeAttackGoal(Incinerator inquisitor) {
            super((PathfinderMob)inquisitor, 1.0, false);
        }
    }
}

