/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.datagen.server;

import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class RaidedLootProvider
extends LootTableProvider {
    public RaidedLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RaidedLootTables::new, LootContextParamSets.ENTITY)), lookupProvider);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        super.validate(writableregistry, validationcontext, problemreporter$collector);
    }

    public static class RaidedLootTables
    extends EntityLootSubProvider {
        protected RaidedLootTables(HolderLookup.Provider provider) {
            super(FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add(RaidedRegistry.INQUISITOR.getEntityType(), LootTable.lootTable());
            this.add(RaidedRegistry.INCINERATOR.getEntityType(), LootTable.lootTable());
            this.add(RaidedRegistry.SAVAGER.getEntityType(), LootTable.lootTable());
            this.add(RaidedRegistry.NECROMANCER.getEntityType(), LootTable.lootTable());
            this.add(RaidedRegistry.ELECTROMANCER.getEntityType(), LootTable.lootTable());
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return RaidedRegistry.ENTITY_TYPES.getEntries().stream().map(Supplier::get);
        }
    }
}

