/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.datagen;

import com.mrbysco.raided.datagen.client.RaidedItemModelsProvider;
import com.mrbysco.raided.datagen.client.RaidedLanguageProvider;
import com.mrbysco.raided.datagen.client.RaidedSoundProvider;
import com.mrbysco.raided.datagen.server.RaidedEntityTypeTagsProvider;
import com.mrbysco.raided.datagen.server.RaidedLootProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RaidedDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new RaidedLootProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new RaidedEntityTypeTagsProvider(packOutput, lookupProvider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new RaidedLanguageProvider(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new RaidedItemModelsProvider(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new RaidedSoundProvider(packOutput, helper));
        }
    }
}

