/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.client.model;

import com.mrbysco.raided.entity.Savager;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SavagerModel<T extends Savager>
extends HierarchicalModel<T>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart upperBody;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart tail;

    public SavagerModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.upperBody = root.getChild("upperBody");
        this.leftFrontLeg = root.getChild("leftFrontLeg");
        this.rightFrontLeg = root.getChild("rightFrontLeg");
        this.body = root.getChild("body");
        this.rightHindLeg = root.getChild("rightHindLeg");
        this.leftHindLeg = root.getChild("leftHindLeg");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeListBuilder.create();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -5.0f, -4.0f, 6.0f, 8.0f, 4.0f).texOffs(0, 12).addBox(-1.0f, 0.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)-6.0f));
        head.addOrReplaceChild("ear_left_r1", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)1.5f, (float)-5.0f, (float)-1.0f, (float)0.5199f, (float)0.0653f, (float)-0.1135f));
        head.addOrReplaceChild("ear_right_r1", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-1.5f, (float)-5.0f, (float)-1.0f, (float)0.5199f, (float)-0.0653f, (float)0.1135f));
        PartDefinition upperBody = partdefinition.addOrReplaceChild("upperBody", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)-2.0f));
        upperBody.addOrReplaceChild("neck_chain_r1", CubeListBuilder.create().texOffs(20, 14).addBox(-2.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        upperBody.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(20, 0).addBox(-4.0f, -6.0f, -4.5f, 8.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(0.5f, 0.0f, -4.5f, 3.0f, 11.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)13.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(0, 18).addBox(-3.5f, 0.0f, -4.5f, 3.0f, 11.0f, 3.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)-2.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)-1.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(20, 14).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(0, 18).addBox(-3.5f, 0.0f, 5.5f, 3.0f, 11.0f, 3.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(0.5f, 0.0f, 5.5f, 3.0f, 11.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)13.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(12, 22).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart getHead() {
        return this.head;
    }

    public ModelPart root() {
        return this.root;
    }

    public void prepareMobModel(T savager, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tail.yRot = 0.0f;
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
    }

    public void setupAnim(T savager, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.tail.xRot = ageInTicks;
    }
}

