/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.datacomponents;

import com.mojang.serialization.Codec;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class VillagerData {
    public static final Codec<VillagerData> CODEC = CompoundTag.CODEC.xmap(VillagerData::of, villagerData -> villagerData.nbt);
    public static final StreamCodec<RegistryFriendlyByteBuf, VillagerData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, VillagerData>(){

        public VillagerData decode(RegistryFriendlyByteBuf buf) {
            return new VillagerData(buf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf buf, VillagerData villager) {
            buf.writeNbt((Tag)villager.nbt);
        }
    };
    private WeakReference<EasyVillagerEntity> villager = new WeakReference<Object>(null);
    private final CompoundTag nbt;

    private VillagerData(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static VillagerData of(CompoundTag nbt) {
        return new VillagerData(nbt.copy());
    }

    public static VillagerData of(Villager villager) {
        CompoundTag nbt = new CompoundTag();
        villager.addAdditionalSaveData(nbt);
        return new VillagerData(nbt);
    }

    @Nullable
    public static VillagerData get(ItemStack stack) {
        if (!(stack.getItem() instanceof VillagerItem)) {
            throw new IllegalArgumentException("Tried to set villager data to non-villager item (%s)".formatted(stack.getHoverName().getString()));
        }
        VillagerData.convert(stack);
        return (VillagerData)stack.get(ModItems.VILLAGER_DATA_COMPONENT);
    }

    public static VillagerData getOrCreate(ItemStack stack) {
        VillagerData villagerData = VillagerData.get(stack);
        if (villagerData == null) {
            villagerData = VillagerData.setEmptyVillagerTag(stack);
        }
        return villagerData;
    }

    public EasyVillagerEntity getCacheVillager(Level level) {
        EasyVillagerEntity easyVillager = (EasyVillagerEntity)((Object)this.villager.get());
        if (easyVillager == null) {
            easyVillager = this.createEasyVillager(level, null);
            this.villager = new WeakReference<EasyVillagerEntity>(easyVillager);
        }
        return easyVillager;
    }

    public EasyVillagerEntity createEasyVillager(Level level, @Nullable ItemStack stack) {
        Component customName;
        EasyVillagerEntity v = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.VILLAGER, level);
        v.readAdditionalSaveData(this.nbt);
        if (stack != null && (customName = (Component)stack.get(DataComponents.CUSTOM_NAME)) != null) {
            v.setCustomName(customName);
        }
        v.hurtTime = 0;
        v.yHeadRot = 0.0f;
        v.yHeadRotO = 0.0f;
        return v;
    }

    public static EasyVillagerEntity createEasyVillager(ItemStack stack, Level level) {
        VillagerData villagerData = VillagerData.getOrCreate(stack);
        return villagerData.createEasyVillager(level, stack);
    }

    public static void applyToItem(ItemStack stack, Villager villager) {
        if (stack.isEmpty()) {
            return;
        }
        stack.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)VillagerData.of(villager));
        if (villager.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)villager.getCustomName());
        }
    }

    public static EasyVillagerEntity getCacheVillager(ItemStack stack, Level level) {
        return VillagerData.getOrCreate(stack).getCacheVillager(level);
    }

    public static void convertInventory(CompoundTag tag, NonNullList<ItemStack> stacks, HolderLookup.Provider provider) {
        ListTag listtag = tag.getList("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag itemTag = listtag.getCompound(i);
            int pos = itemTag.getByte("Slot") & 0xFF;
            if (pos >= stacks.size()) continue;
            ItemStack convert = VillagerData.convert(provider, itemTag);
            stacks.set(pos, (Object)convert);
        }
    }

    public static ItemStack convert(HolderLookup.Provider provider, CompoundTag itemCompound) {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemCompound);
        if (stack.isEmpty()) {
            return stack;
        }
        if (!(stack.getItem() instanceof VillagerItem)) {
            return stack;
        }
        if (stack.has(ModItems.VILLAGER_DATA_COMPONENT)) {
            return stack;
        }
        if (!itemCompound.contains("tag", 10)) {
            return stack;
        }
        CompoundTag tag = itemCompound.getCompound("tag");
        if (!tag.contains("villager", 10)) {
            return stack;
        }
        CompoundTag villagerTag = tag.getCompound("villager");
        VillagerData villagerData = VillagerData.of(villagerTag);
        stack.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)villagerData);
        return stack;
    }

    public static void convert(ItemStack stack) {
        if (!(stack.getItem() instanceof VillagerItem)) {
            return;
        }
        if (stack.has(ModItems.VILLAGER_DATA_COMPONENT)) {
            return;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            VillagerData.setEmptyVillagerTag(stack);
            return;
        }
        CompoundTag customTag = customData.copyTag();
        if (!customTag.contains("villager", 10)) {
            VillagerData.setEmptyVillagerTag(stack);
            return;
        }
        CompoundTag villagerTag = customTag.getCompound("villager");
        customTag.remove("villager");
        if (customTag.isEmpty()) {
            stack.remove(DataComponents.CUSTOM_DATA);
        } else {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customTag));
        }
        VillagerData villagerData = VillagerData.of(villagerTag);
        stack.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)villagerData);
    }

    private static VillagerData setEmptyVillagerTag(ItemStack stack) {
        VillagerData villagerData = new VillagerData(new CompoundTag());
        stack.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)villagerData);
        return villagerData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VillagerData villager1 = (VillagerData)o;
        return Objects.equals(this.nbt, villager1.nbt);
    }

    public int hashCode() {
        return Objects.hashCode(this.nbt);
    }
}

