/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import org.apache.commons.lang3.math.Fraction;
import org.cyclops.commoncapabilities.capability.itemhandler.ItemItemHandler;
import org.jetbrains.annotations.NotNull;

public class VanillaItemBundleItemHandler
extends ItemItemHandler {
    public VanillaItemBundleItemHandler(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    protected NonNullList<ItemStack> getItemList() {
        BundleContents container = (BundleContents)this.getItemStack().get(DataComponents.BUNDLE_CONTENTS);
        if (container != null) {
            NonNullList list = NonNullList.create();
            container.itemCopyStream().forEach(arg_0 -> list.add(arg_0));
            list.add((Object)ItemStack.EMPTY);
            return list;
        }
        return NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    }

    @Override
    protected void setItemList(NonNullList<ItemStack> itemStacks) {
        this.getItemStack().set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(itemStacks.stream().filter(s -> !s.isEmpty()).toList()));
    }

    public int getSlots() {
        return this.getItemList().size();
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.isEmpty() || this.getMaxAmountToAdd(stack) > 0;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isItemValid(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        int insertCount = Math.min(this.getMaxAmountToAdd(stack), stack.getCount());
        int notInserting = stack.getCount() - insertCount;
        ItemStack remaining = super.insertItem(slot, stack.copyWithCount(insertCount), simulate);
        if (notInserting > 0) {
            if (remaining.isEmpty()) {
                remaining = stack.copy();
                remaining.setCount(notInserting);
            } else {
                remaining.grow(notInserting);
            }
        }
        return remaining;
    }

    private int getMaxAmountToAdd(ItemStack stackToAdd) {
        BundleContents container = (BundleContents)this.getItemStack().get(DataComponents.BUNDLE_CONTENTS);
        Fraction fraction = Fraction.ONE.subtract(container.weight());
        return Math.max(fraction.divideBy(BundleContents.getWeight((ItemStack)stackToAdd)).intValue(), 0);
    }
}

