/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.neoforge;

import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.fluids.neoforge.SoftFluidStackImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public record SoftFluidTankFluidHandlerWrapper(SoftFluidTank tank, BlockEntity be) implements IFluidHandler
{
    public static <T extends BlockEntity> SoftFluidTankFluidHandlerWrapper wrap(T be) {
        return new SoftFluidTankFluidHandlerWrapper(((ISoftFluidTankProvider)be).getSoftFluidTank(), be);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return SoftFluidStackImpl.toForgeFluid(this.tank.getFluid());
    }

    public int getTankCapacity(int i) {
        return SoftFluidStackImpl.bottlesToMB(this.tank.getCapacity());
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return this.tank.isFluidCompatible(SoftFluidStackImpl.fromForgeFluid(fluidStack, (HolderLookup.Provider)this.be.getLevel().registryAccess()));
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        SoftFluidStack original = SoftFluidStackImpl.fromForgeFluid(fluidStack, (HolderLookup.Provider)this.be.getLevel().registryAccess());
        int filled = this.tank.addFluid(original, fluidAction.simulate());
        if (!fluidAction.simulate()) {
            int bottlesRemoved = SoftFluidStackImpl.fromForgeFluid(fluidStack, (HolderLookup.Provider)this.be.getLevel().registryAccess()).getCount() - original.getCount();
            fluidStack.shrink(SoftFluidStackImpl.bottlesToMB(bottlesRemoved));
            this.be.setChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return this.drain(fluidStack.getAmount(), fluidAction);
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        SoftFluidStack drained = this.tank.removeFluid(i, fluidAction.simulate());
        if (!fluidAction.simulate()) {
            this.be.setChanged();
        }
        return SoftFluidStackImpl.toForgeFluid(drained);
    }
}

