/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface IOwnerProtected {
    @Nullable
    public UUID getOwner();

    public void setOwner(@Nullable UUID var1);

    default public void saveOwner(CompoundTag tag) {
        UUID owner = this.getOwner();
        if (owner != null) {
            tag.putUUID("Owner", owner);
        }
    }

    default public void loadOwner(CompoundTag tag) {
        if (tag.contains("Owner")) {
            this.setOwner(tag.getUUID("Owner"));
        }
    }

    default public boolean isOwnedBy(Player player) {
        UUID id = this.getOwner();
        return id != null && id.equals(player.getUUID());
    }

    default public boolean isPublic() {
        return this.getOwner() == null;
    }

    default public boolean isAccessibleBy(Player player) {
        return this.isPublic() || this.isOwnedBy(player);
    }

    default public boolean isNotOwnedBy(Player player) {
        UUID id = this.getOwner();
        return id != null && !id.equals(player.getUUID());
    }
}

