/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.postprocess;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderSystem;

public abstract class PostProcessor {
    protected static final Minecraft MC = Minecraft.getInstance();
    public static final Collection<Pair<String, Consumer<Uniform>>> COMMON_UNIFORMS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"cameraPos", u -> u.set(new Vector3f((Vector3fc)PostProcessor.MC.gameRenderer.getMainCamera().getPosition().toVector3f()))), Pair.of((Object)"lookVector", u -> u.set(PostProcessor.MC.gameRenderer.getMainCamera().getLookVector())), Pair.of((Object)"upVector", u -> u.set(PostProcessor.MC.gameRenderer.getMainCamera().getUpVector())), Pair.of((Object)"leftVector", u -> u.set(PostProcessor.MC.gameRenderer.getMainCamera().getLeftVector())), Pair.of((Object)"invViewMat", u -> u.set(viewModelMatrix.invert(new Matrix4f()))), Pair.of((Object)"invProjMat", u -> u.set(RenderSystem.getProjectionMatrix().invert(new Matrix4f()))), Pair.of((Object)"nearPlaneDistance", u -> u.set(0.05f)), Pair.of((Object)"farPlaneDistance", u -> u.set(PostProcessor.MC.gameRenderer.getDepthFar())), Pair.of((Object)"fov", u -> u.set((float)Math.toRadians(PostProcessor.MC.gameRenderer.getFov(PostProcessor.MC.gameRenderer.getMainCamera(), MC.getTimer().getGameTimeDeltaPartialTick(false), true)))), Pair.of((Object)"aspectRatio", u -> u.set((float)MC.getWindow().getWidth() / (float)MC.getWindow().getHeight())), Pair.of((Object)"bobOffset", u -> u.set(viewModelMatrix.invert(new Matrix4f()).transformPosition(LodestoneRenderSystem.getViewBobOffset(), new Vector3f())))});
    public static Matrix4f viewModelMatrix;
    private boolean initialized = false;
    protected PostChain postChain;
    protected EffectInstance[] effects;
    private RenderTarget tempDepthBuffer;
    private Collection<Pair<Uniform, Consumer<Uniform>>> defaultUniforms;
    private boolean isActive = true;
    protected double time;

    public abstract ResourceLocation getPostChainLocation();

    public void init() {
        this.loadPostChain();
        if (this.postChain != null) {
            this.tempDepthBuffer = this.postChain.getTempTarget("depthMain");
            this.defaultUniforms = new ArrayList<Pair<Uniform, Consumer<Uniform>>>();
            for (EffectInstance e : this.effects) {
                for (Pair<String, Consumer<Uniform>> pair : COMMON_UNIFORMS) {
                    Uniform u = e.getUniform((String)pair.getFirst());
                    if (u == null) continue;
                    this.defaultUniforms.add((Pair<Uniform, Consumer<Uniform>>)Pair.of((Object)u, (Object)((Consumer)pair.getSecond())));
                }
            }
        }
        this.initialized = true;
    }

    public final void loadPostChain() {
        if (this.postChain != null) {
            this.postChain.close();
            this.postChain = null;
        }
        try {
            ResourceLocation file = this.getPostChainLocation();
            file = ResourceLocation.fromNamespaceAndPath((String)file.getNamespace(), (String)("shaders/post/" + file.getPath() + ".json"));
            this.postChain = new PostChain(MC.getTextureManager(), (ResourceProvider)MC.getResourceManager(), MC.getMainRenderTarget(), file);
            this.postChain.resize(MC.getWindow().getWidth(), MC.getWindow().getHeight());
            this.effects = (EffectInstance[])this.postChain.passes.stream().map(PostPass::getEffect).toArray(EffectInstance[]::new);
        }
        catch (JsonParseException | IOException e) {
            LodestoneLib.LOGGER.error("Failed to load post-processing shader: ", e);
        }
    }

    public final void copyDepthBuffer() {
        if (this.isActive) {
            if (this.postChain == null || this.tempDepthBuffer == null) {
                return;
            }
            this.tempDepthBuffer.copyDepthFrom(MC.getMainRenderTarget());
            GlStateManager._glBindFramebuffer((int)36009, (int)PostProcessor.MC.getMainRenderTarget().frameBufferId);
        }
    }

    public void resize(int width, int height) {
        if (this.postChain != null) {
            this.postChain.resize(width, height);
            if (this.tempDepthBuffer != null) {
                this.tempDepthBuffer.resize(width, height, Minecraft.ON_OSX);
            }
        }
    }

    private void applyDefaultUniforms() {
        Arrays.stream(this.effects).forEach(e -> e.safeGetUniform("time").set((float)this.time));
        this.defaultUniforms.forEach(pair -> ((Consumer)pair.getSecond()).accept((Uniform)pair.getFirst()));
    }

    public final void applyPostProcess() {
        if (this.isActive) {
            if (!this.initialized) {
                this.init();
            }
            if (this.postChain != null) {
                this.time += (double)MC.getTimer().getGameTimeDeltaPartialTick(false) / 20.0;
                this.beforeProcess(viewModelMatrix);
                this.applyDefaultUniforms();
                if (!this.isActive) {
                    return;
                }
                this.postChain.process(MC.getTimer().getGameTimeDeltaPartialTick(false));
                GlStateManager._glBindFramebuffer((int)36009, (int)PostProcessor.MC.getMainRenderTarget().frameBufferId);
                this.afterProcess();
            }
        }
    }

    public abstract void beforeProcess(Matrix4f var1);

    public abstract void afterProcess();

    public void setActive(boolean active) {
        this.isActive = active;
        if (!active) {
            this.time = 0.0;
        }
    }

    public final boolean isActive() {
        return this.isActive;
    }
}

