/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.enchanting;

import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LodestoneEnchantmentEffectCommonsHelper {
    public static boolean isChargedAttack(LivingEntity attacker) {
        return LodestoneEnchantmentEffectCommonsHelper.isChargedAttack(attacker, 0.9f);
    }

    public static boolean isChargedAttack(LivingEntity attacker, float threshold) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            return !(player.getAttackStrengthScale(0.5f) <= threshold);
        }
        return true;
    }

    public static boolean disableShield(LivingEntity shieldUser, ItemStack stack, int duration) {
        return LodestoneEnchantmentEffectCommonsHelper.disableShield(shieldUser, stack, duration, true);
    }

    public static boolean disableShield(LivingEntity shieldUser, ItemStack stack, int duration, boolean swing) {
        if (shieldUser instanceof Player) {
            Player player = (Player)shieldUser;
            Item shieldItem = stack.getItem();
            boolean wasOnCooldown = player.getCooldowns().isOnCooldown(shieldItem);
            player.stopUsingItem();
            if (!player.isCreative() && !wasOnCooldown) {
                player.getCooldowns().addCooldown(shieldItem, duration);
            }
            return !wasOnCooldown;
        }
        if (swing) {
            InteractionHand hand = shieldUser.getMainHandItem().equals(stack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            shieldUser.swing(hand, true);
        }
        return true;
    }

    public static Predicate<LivingEntity> attackPredicate(LivingEntity attacker) {
        return entity -> {
            ArmorStand armorstand;
            TamableAnimal tamableanimal;
            if (entity.isSpectator()) {
                return false;
            }
            if (entity == attacker) {
                return false;
            }
            if (attacker.isAlliedTo((Entity)entity)) {
                return false;
            }
            if (entity instanceof TamableAnimal && (tamableanimal = (TamableAnimal)entity).isTame() && attacker.getUUID().equals(tamableanimal.getOwnerUUID())) {
                return false;
            }
            return !(entity instanceof ArmorStand) || !(armorstand = (ArmorStand)entity).isMarker();
        };
    }
}

