/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.enchanting;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.neoforged.neoforge.common.util.AttributeUtil;
import org.apache.commons.lang3.mutable.MutableFloat;
import team.lodestar.lodestone.registry.common.LodestoneEnchantmentComponents;
import team.lodestar.lodestone.systems.enchanting.LodestoneEnchantmentDataHelper;

public class LodestoneEnchantmentAttributeHelper {
    public static float getAttributeValue(ItemStack stack, @Nullable Holder<Enchantment> filter, Holder<Attribute> attribute, float baseValue) {
        MutableFloat mutable = new MutableFloat(baseValue);
        LodestoneEnchantmentDataHelper.runIterationOnItem(stack, filter, (enchantment, level) -> ((Enchantment)enchantment.value()).getEffects(EnchantmentEffectComponents.ATTRIBUTES).forEach(effect -> {
            if (effect.attribute().equals((Object)attribute)) {
                AttributeModifier modifier = effect.getModifier(level, (StringRepresentable)EquipmentSlotGroup.ANY);
                mutable.setValue(LodestoneEnchantmentAttributeHelper.compute(modifier, mutable.getValue().floatValue()));
            }
        }));
        LodestoneEnchantmentDataHelper.runIterationOnItem(stack, filter, (enchantment, level) -> ((Enchantment)enchantment.value()).getEffects(LodestoneEnchantmentComponents.SLOT_BOUND_ATTRIBUTES.get()).forEach(effect -> {
            if (effect.attribute().equals((Object)attribute)) {
                AttributeModifier modifier = effect.getModifier(level, (StringRepresentable)EquipmentSlotGroup.ANY);
                mutable.setValue(LodestoneEnchantmentAttributeHelper.compute(modifier, mutable.getValue().floatValue()));
            }
        }));
        return mutable.getValue().floatValue();
    }

    public static float getBaseValue(ItemAttributeModifiers modifiers, float baseValue, Holder<Attribute> attribute) {
        return LodestoneEnchantmentAttributeHelper.compute(modifiers, e -> e.attribute().equals((Object)attribute) && LodestoneEnchantmentAttributeHelper.isBaseAttribute(e), baseValue);
    }

    public static boolean isBaseAttribute(ItemAttributeModifiers.Entry entry) {
        return !entry.modifier().id().getPath().contains("enchantment");
    }

    public static ItemAttributeModifiers asAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        for (Map.Entry entry : map.entries()) {
            builder.add((Holder)entry.getKey(), (AttributeModifier)entry.getValue(), EquipmentSlotGroup.ANY);
        }
        return builder.build();
    }

    public static float compute(ItemAttributeModifiers modifiers, Predicate<ItemAttributeModifiers.Entry> filter, double baseValue) {
        double value = baseValue;
        Multimap<Holder<Attribute>, AttributeModifier> matching = LodestoneEnchantmentAttributeHelper.findMatching(modifiers, filter);
        for (Map.Entry entry : matching.entries()) {
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            value = LodestoneEnchantmentAttributeHelper.compute(modifier, value);
        }
        return (float)value;
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> findMatching(ItemAttributeModifiers modifiers, Predicate<ItemAttributeModifiers.Entry> filter) {
        Multimap map = AttributeUtil.sortedMap();
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!filter.test(entry)) continue;
            map.put((Object)entry.attribute(), (Object)entry.modifier());
        }
        return map;
    }

    public static float compute(AttributeModifier modifier, double baseValue) {
        double value = baseValue;
        double d1 = modifier.amount();
        return (float)(value += (switch (modifier.operation()) {
            default -> throw new MatchException(null, null);
            case AttributeModifier.Operation.ADD_VALUE -> d1;
            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * baseValue;
            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * value;
        }));
    }
}

