/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import team.lodestar.lodestone.attachment.WorldEventAttachment;
import team.lodestar.lodestone.events.types.worldevent.WorldEventRenderEvent;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneWorldEventRenderers;
import team.lodestar.lodestone.registry.common.LodestoneAttachmentTypes;
import team.lodestar.lodestone.systems.rendering.buffer.LodestoneBufferSource;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventRenderer;

public class WorldEventRenderHandler {
    public static void renderWorldEvents(ClientLevel level, PoseStack poseStack, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        WorldEventAttachment worldData = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
        for (WorldEventInstance instance : worldData.activeWorldEvents) {
            WorldEventRenderer<WorldEventInstance> renderer = LodestoneWorldEventRenderers.RENDERERS.get(instance.type);
            if (renderer == null || !renderer.canRender(instance)) continue;
            LodestoneBufferSource target = LodestoneRenderHandler.DEFERRED_RENDER.getTarget();
            NeoForge.EVENT_BUS.post((Event)new WorldEventRenderEvent(instance, renderer, poseStack, (MultiBufferSource)target, partialTicks));
            renderer.render(instance, poseStack, (MultiBufferSource)target, partialTicks);
        }
        poseStack.popPose();
    }
}

