/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.packingtape.tape;

import dev.gigaherz.packingtape.PackingTapeMod;
import dev.gigaherz.packingtape.tape.ContainedBlockData;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PackagedBlockEntity
extends BlockEntity {
    private static Logger LOGGER = LogManager.getLogger();
    private BlockState containedBlockState;
    private CompoundTag containedTile;
    private Direction preferredAll;
    private Direction preferredHorizontal;

    public PackagedBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public PackagedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackingTapeMod.PACKAGED_BLOCK_ENTITY.get(), pos, state);
    }

    public void setContents(BlockState state, CompoundTag tag) {
        this.containedBlockState = state;
        this.containedTile = tag;
    }

    @Nullable
    public BlockState getContainedBlockState() {
        return this.containedBlockState;
    }

    @Nullable
    public CompoundTag getContainedTile() {
        return this.containedTile;
    }

    @Nullable
    public Direction getPreferredDirectionAll() {
        return this.preferredAll;
    }

    @Nullable
    public Direction getPreferredDirectionHorizontal() {
        return this.preferredHorizontal;
    }

    public void setPreferredDirection(Direction preferredAll, Direction preferredHorizontal) {
        this.preferredAll = preferredAll;
        this.preferredHorizontal = preferredHorizontal;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.containedBlockState != null) {
            CompoundTag blockData = NbtUtils.writeBlockState((BlockState)this.containedBlockState);
            compound.put("Block", (Tag)blockData);
            compound.put("BlockEntity", (Tag)this.containedTile.copy());
            if (this.preferredAll != null) {
                compound.putString("PreferredDirection", this.preferredAll.getSerializedName());
            }
            if (this.preferredHorizontal != null) {
                compound.putString("PreferredHorizontal", this.preferredHorizontal.getSerializedName());
            }
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        int ordinal;
        Direction[] values;
        super.loadAdditional(compound, provider);
        HolderLookup.RegistryLookup holdergetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        CompoundTag blockTag = compound.getCompound("Block");
        this.containedBlockState = NbtUtils.readBlockState((HolderGetter)holdergetter, (CompoundTag)blockTag);
        this.containedTile = compound.getCompound("BlockEntity").copy();
        if (compound.contains("PreferredDirection", 8)) {
            this.preferredAll = Direction.byName((String)compound.getString("PreferredDirection"));
        } else if (compound.contains("PreferredDirection", 99)) {
            values = Direction.values();
            ordinal = compound.getInt("PreferredDirection");
            if (ordinal >= 0 && ordinal < values.length) {
                this.preferredAll = values[ordinal];
            }
        }
        if (compound.contains("PreferredHorizontal", 8)) {
            this.preferredHorizontal = Direction.byName((String)compound.getString("PreferredHorizontal"));
        } else if (compound.contains("PreferredHorizontal", 99)) {
            values = Direction.values();
            ordinal = compound.getInt("PreferredHorizontal");
            if (ordinal >= 0 && ordinal < values.length) {
                this.preferredHorizontal = values[ordinal];
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        ContainedBlockData data = (ContainedBlockData)input.get(PackingTapeMod.CONTAINED_BLOCK);
        if (data != null) {
            this.containedBlockState = data.state();
            this.containedTile = data.blockEntityTag();
            this.preferredAll = data.preferredAll().orElse(null);
            this.preferredHorizontal = data.preferredHorizontal().orElse(null);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder collector) {
        if (this.containedBlockState != null) {
            collector.set(PackingTapeMod.CONTAINED_BLOCK, (Object)this.makeContainedData());
        }
    }

    @NotNull
    private ContainedBlockData makeContainedData() {
        return new ContainedBlockData(Objects.requireNonNull(this.containedBlockState), Objects.requireNonNullElseGet(this.containedTile, CompoundTag::new), Optional.ofNullable(this.preferredAll), Optional.ofNullable(this.preferredHorizontal));
    }

    public ItemStack getPackedStack() {
        ItemStack stack = new ItemStack((ItemLike)PackingTapeMod.PACKAGED_BLOCK.get());
        stack.set(PackingTapeMod.CONTAINED_BLOCK, (Object)this.makeContainedData());
        LOGGER.debug(String.format("Created Packed stack with %s", this.containedBlockState.toString()));
        return stack;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadWithComponents(tag, provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.handleUpdateTag(pkt.getTag(), provider);
    }

    public boolean isEmpty() {
        return this.containedBlockState == null || this.containedBlockState.isAir();
    }
}

