/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.packingtape;

import dev.gigaherz.packingtape.PackingTapeMod;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigValues {
    public static final ServerConfig SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    public static int tapeRollUses;
    public static boolean consumesPaper;
    public static int maxStorageSize;
    public static TagKey<BlockEntityType<?>> TE_WHITELIST;
    public static TagKey<BlockEntityType<?>> TE_BLACKLIST;
    public static TagKey<Block> BLOCK_WHITELIST;
    public static TagKey<Block> BLOCK_BLACKLIST;

    public static void bake() {
        tapeRollUses = (Integer)ConfigValues.SERVER.tapeRollUses.get();
        consumesPaper = (Boolean)ConfigValues.SERVER.consumesPaper.get();
        maxStorageSize = (Integer)ConfigValues.SERVER.maxStorageSize.get();
    }

    public static boolean isBlockEntityWhitelisted(BlockEntity be) {
        Block block = be.getBlockState().getBlock();
        ResourceKey rk0 = (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)block).orElseThrow();
        Holder.Reference holder0 = (Holder.Reference)BuiltInRegistries.BLOCK.getHolder(rk0).orElseThrow();
        if (holder0.is(BLOCK_WHITELIST)) {
            return true;
        }
        BlockEntityType type = be.getType();
        ResourceKey rk1 = (ResourceKey)BuiltInRegistries.BLOCK_ENTITY_TYPE.getResourceKey((Object)type).orElseThrow();
        Holder.Reference holder1 = (Holder.Reference)BuiltInRegistries.BLOCK_ENTITY_TYPE.getHolder(rk1).orElseThrow();
        return holder1.is(TE_WHITELIST);
    }

    public static boolean isBlockEntityBlocked(BlockEntity be) {
        Block block = be.getBlockState().getBlock();
        ResourceKey rk0 = (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)block).orElseThrow();
        Holder.Reference holder0 = (Holder.Reference)BuiltInRegistries.BLOCK.getHolder(rk0).orElseThrow();
        if (holder0.is(BLOCK_WHITELIST)) {
            return false;
        }
        if (holder0.is(BLOCK_BLACKLIST)) {
            return true;
        }
        BlockEntityType type = be.getType();
        ResourceKey rk1 = (ResourceKey)BuiltInRegistries.BLOCK_ENTITY_TYPE.getResourceKey((Object)type).orElseThrow();
        Holder.Reference holder1 = (Holder.Reference)BuiltInRegistries.BLOCK_ENTITY_TYPE.getHolder(rk1).orElseThrow();
        if (holder1.is(TE_WHITELIST)) {
            return false;
        }
        if (be.onlyOpCanSetNbt()) {
            return true;
        }
        return holder1.is(TE_BLACKLIST);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        tapeRollUses = 8;
        consumesPaper = true;
        maxStorageSize = 1000000;
        TE_WHITELIST = TagKey.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)PackingTapeMod.location("te_whitelist"));
        TE_BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)PackingTapeMod.location("te_blacklist"));
        BLOCK_WHITELIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)PackingTapeMod.location("te_whitelist"));
        BLOCK_BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)PackingTapeMod.location("te_blacklist"));
    }

    public static class ServerConfig {
        public ModConfigSpec.IntValue tapeRollUses;
        public ModConfigSpec.BooleanValue consumesPaper;
        public ModConfigSpec.IntValue maxStorageSize;

        ServerConfig(ModConfigSpec.Builder builder) {
            builder.push("general");
            this.tapeRollUses = builder.comment("How many times the tape roll can be used before it breaks").defineInRange("tape_roll_uses", 8, 0, 0x7FFFFFFE);
            this.consumesPaper = builder.comment("Whether the tape roll consumes paper when used").define("consume_paper", true);
            this.maxStorageSize = builder.comment("How much space (in bytes) the packaged block contents can take up.").defineInRange("max_storage_size", 1000000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

