/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.network;

import com.hollingsworth.ars_creo.ArsCreo;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PacketUpdateJarContraption
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketUpdateJarContraption> TYPE = new CustomPacketPayload.Type(ArsCreo.prefix("update_jar"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateJarContraption> CODEC = StreamCodec.ofMember(PacketUpdateJarContraption::toBytes, PacketUpdateJarContraption::new);
    public int entityID;
    public BlockPos structurePos;
    public CompoundTag structureTag;
    public int fillLevel;

    public PacketUpdateJarContraption(FriendlyByteBuf buf) {
        this.structurePos = buf.readBlockPos();
        this.structureTag = buf.readNbt();
        this.fillLevel = buf.readInt();
        this.entityID = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.structurePos);
        buf.writeNbt((Tag)this.structureTag);
        buf.writeInt(this.fillLevel);
        buf.writeInt(this.entityID);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        Entity entity = ArsNouveau.proxy.getClientWorld().getEntity(this.entityID);
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraption = (AbstractContraptionEntity)entity;
            contraption.getContraption().getBlocks().put(this.structurePos, new StructureTemplate.StructureBlockInfo(this.structurePos, (BlockState)BlockRegistry.SOURCE_JAR.defaultBlockState().setValue(SourceJar.fill, (Comparable)Integer.valueOf(this.fillLevel)), this.structureTag));
            contraption.getContraption().invalidateClientContraptionStructure();
        }
    }
}

