/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.util;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CollideUtil {
    public static Vec3 getPrevPositionVec(Entity collideEntity) {
        return new Vec3(collideEntity.xOld, collideEntity.yOld, collideEntity.zOld);
    }

    public static void collideEntities(Entity collideEntity) {
        Level world = collideEntity.level();
        AABB bounds = collideEntity.getBoundingBox();
        if (bounds == null) {
            return;
        }
        Vec3 position = collideEntity.position();
        Vec3 motion = position.subtract(CollideUtil.getPrevPositionVec(collideEntity));
        AABB boundCheck = bounds.inflate((double)0.18f);
        List entitiesWithinAABB = world.getEntitiesOfClass(Entity.class, boundCheck);
        for (Entity entity : entitiesWithinAABB) {
            if (entity == collideEntity || collideEntity.isPassenger() || entity.canBeCollidedWith()) continue;
            Vec3 entityPosition = entity.position();
            Vec3 entityMotion = position.subtract(CollideUtil.getPrevPositionVec(entity));
            Vec3 vec3 = entity.collide(motion);
            if (!boundCheck.expandTowards(motion).intersects(entity.getBoundingBox())) continue;
            entity.setPos(entityPosition.x + vec3.x, entityPosition.y + vec3.y, entityPosition.z + vec3.z);
            entity.setOnGround(true);
            entity.fallDistance = 0.0f;
        }
    }
}

