/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.loot;

import bagu_chan.bagus_lib.register.ModLootModifiers;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class LootInLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<LootInLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> LootInLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(m -> m.lootTable)).apply((Applicative)inst, LootInLootModifier::new)));
    public final ResourceLocation lootTable;

    protected LootInLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Optional extraTable = context.getResolver().get(Registries.LOOT_TABLE, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable));
        if (extraTable.isPresent()) {
            ((LootTable)((Holder.Reference)extraTable.get()).value()).getRandomItemsRaw(context, arg_0 -> generatedLoot.add(arg_0));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)ModLootModifiers.LOOT_IN_LOOT_MODIFIER.get();
    }
}

