/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.dialog;

import bagu_chan.bagus_lib.client.dialog.DialogOption;
import bagu_chan.bagus_lib.client.dialog.DialogType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ImageDialogType
extends DialogType {
    public static final MapCodec<ImageDialogType> CODEC = RecordCodecBuilder.mapCodec(p_345644_ -> p_345644_.group((App)Codec.STRING.fieldOf("dialog").forGetter(DialogType::getDialogueBase), (App)DialogOption.CODEC.fieldOf("dialog_option").orElse((Object)new DialogOption(1.0f, 1.0f, true, Optional.empty())).forGetter(DialogType::getDialogueOption), (App)Codec.LONG.fieldOf("dialog_render_time").forGetter(DialogType::getDialogRenderTime), (App)Codec.DOUBLE.fieldOf("draw_per_tick").forGetter(DialogType::getDialogPerTick), (App)ResourceLocation.CODEC.optionalFieldOf("image").forGetter(ImageDialogType::getImage), (App)Codec.INT.fieldOf("texture_size_x").forGetter(ImageDialogType::getTextureSizeX), (App)Codec.INT.fieldOf("texture_size_y").forGetter(ImageDialogType::getTextureSizeY)).apply((Applicative)p_345644_, ImageDialogType::new));
    protected final Optional<ResourceLocation> image;
    private final int textureSizeX;
    private final int textureSizeY;

    public ImageDialogType(String dialogueBase, DialogOption dialogueOption, long dialogRenderTime, double dialogPerTick, Optional<ResourceLocation> image, int textureSizeX, int textureSizeY) {
        super(dialogueBase, dialogueOption, dialogRenderTime, dialogPerTick);
        this.image = image;
        this.textureSizeX = textureSizeX;
        this.textureSizeY = textureSizeY;
    }

    @Override
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount, int y) {
        if (this.image.isPresent()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, (float)y, 0.0f);
            poseStack.scale(this.dialogueOption.scaleX(), this.dialogueOption.scaleY(), 1.0f);
            guiGraphics.blitSprite(this.image.get(), 0, 0, this.textureSizeX, this.textureSizeY);
            poseStack.popPose();
        }
    }

    @Nullable
    public Optional<ResourceLocation> getImage() {
        return this.image;
    }

    public int getTextureSizeX() {
        return this.textureSizeX;
    }

    public int getTextureSizeY() {
        return this.textureSizeY;
    }

    public MapCodec<ImageDialogType> codec() {
        return CODEC;
    }
}

