/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dmmttba.data;

import com.mrbysco.dmmttba.Constants;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DMMTTBADatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new BoatEntityTagProvider(packOutput, lookupProvider, helper));
        }
    }

    public static class BoatEntityTagProvider
    extends EntityTypeTagsProvider {
        public BoatEntityTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture, ExistingFileHelper existingFileHelper) {
            super(packOutput, completableFuture, "dmmttba", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(Tags.EntityTypes.BOATS).addOptional(ResourceLocation.fromNamespaceAndPath((String)"thermal", (String)"rubberwood_boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"thermal", (String)"rubberwood_chest_boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"chest_boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"terraform", (String)"boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"terraform", (String)"chest_boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"blueprint", (String)"boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"blueprint", (String)"chest_boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"blueprint", (String)"chest_boat")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"utilitix", (String)"shulker_boat"));
            this.tag(Constants.STEERABLE).addTag(Tags.EntityTypes.BOATS);
        }
    }
}

