/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.vectorartmodule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolscontrol.compat.rftoolssupport.ModuleDataVectorArt;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record VectorArtScreenModule(ResourceKey<Level> dim, BlockPos coordinate, String monitorName) implements IScreenModule<VectorArtScreenModule, ModuleDataVectorArt>
{
    public static final VectorArtScreenModule DEFAULT = new VectorArtScreenModule((ResourceKey<Level>)Level.OVERWORLD, BlockPosTools.INVALID, "");
    public static final Codec<VectorArtScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dim").forGetter(VectorArtScreenModule::dim), (App)BlockPos.CODEC.fieldOf("coordinate").forGetter(VectorArtScreenModule::coordinate), (App)Codec.STRING.fieldOf("monitorName").forGetter(VectorArtScreenModule::monitorName)).apply((Applicative)instance, VectorArtScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VectorArtScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), VectorArtScreenModule::dim, (StreamCodec)BlockPos.STREAM_CODEC, VectorArtScreenModule::coordinate, (StreamCodec)ByteBufCodecs.STRING_UTF8, VectorArtScreenModule::monitorName, VectorArtScreenModule::new);

    public VectorArtScreenModule withTarget(ResourceKey<Level> newDim, BlockPos newCoordinate, String name) {
        return new VectorArtScreenModule(newDim, newCoordinate, name);
    }

    public VectorArtScreenModule clearTarget() {
        return new VectorArtScreenModule(this.dim, BlockPosTools.INVALID, "");
    }

    public ModuleDataVectorArt getData(IScreenDataHelper helper, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!BlockPosTools.isValid((BlockPos)this.coordinate) || !LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.getBlockState(this.coordinate).getBlock();
        if (block != ProcessorModule.PROCESSOR.block().get()) {
            return null;
        }
        BlockEntity te = world.getBlockEntity(this.coordinate);
        if (te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            return new ModuleDataVectorArt(processor.getGfxOps(), processor.getOrderedOps());
        }
        return null;
    }

    public int getRfPerTick() {
        return (Integer)Config.VECTORARTMODULE_RFPERTICK.get();
    }

    public VectorArtScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        if (!Objects.equals(world.dimension(), this.dim)) {
            return new VectorArtScreenModule((ResourceKey<Level>)world.dimension(), BlockPosTools.INVALID, "");
        }
        if (!BlockPosTools.isValid((BlockPos)this.coordinate)) {
            return this;
        }
        int dx = Math.abs(this.coordinate.getX() - pos.getX());
        int dy = Math.abs(this.coordinate.getY() - pos.getY());
        int dz = Math.abs(this.coordinate.getZ() - pos.getZ());
        if (dx <= 64 && dy <= 64 && dz <= 64) {
            return this;
        }
        return this.clearTarget();
    }

    @NotNull
    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        BlockEntity te;
        if (!BlockPosTools.isValid((BlockPos)this.coordinate)) {
            if (player != null) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Module is not linked to a processor!")), false);
            }
            return moduleStack;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return moduleStack;
        }
        Block block = world.getBlockState(this.coordinate).getBlock();
        if (block != ProcessorModule.PROCESSOR.block().get()) {
            return moduleStack;
        }
        if (clicked && (te = world.getBlockEntity(this.coordinate)) instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.signal(new Tuple(x, y + 7));
        }
        return moduleStack;
    }
}

