/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.vectorartmodule;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.items.vectorartmodule.VectorArtClientScreenModule;
import mcjty.rftoolscontrol.modules.various.items.vectorartmodule.VectorArtScreenModule;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VectorArtModuleItem
extends GenericModuleItem {
    public VectorArtModuleItem() {
        super(RFToolsControl.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return VectorArtScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return VectorArtScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)VariousModule.VECTORART_MODULE_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return VectorArtScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new VectorArtClientScreenModule();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)Config.VECTORARTMODULE_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public String getModuleName() {
        return "VAR";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.block(stack -> GlobalPos.of(VectorArtModuleItem.data(stack).dim(), (BlockPos)VectorArtModuleItem.data(stack).coordinate()), stack -> VectorArtModuleItem.data(stack).monitorName()).nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block == ProcessorModule.PROCESSOR.block().get()) {
            String name = Tools.getReadableName((Level)world, (BlockPos)pos);
            VectorArtModuleItem.data(stack, module -> module.withTarget((ResourceKey<Level>)world.dimension(), pos, name));
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Vector art module is set to block");
            }
        } else {
            VectorArtModuleItem.data(stack, VectorArtScreenModule::clearTarget);
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Vector art module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static VectorArtScreenModule data(ItemStack stack) {
        VectorArtScreenModule data = (VectorArtScreenModule)stack.get(VariousModule.VECTORART_MODULE_DATA);
        if (data == null) {
            data = VectorArtScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<VectorArtScreenModule, VectorArtScreenModule> setter) {
        VectorArtScreenModule data = VectorArtModuleItem.data(stack);
        data = setter.apply(data);
        stack.set((DataComponentType)VariousModule.VECTORART_MODULE_DATA.get(), (Object)data);
    }
}

