/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.programmer.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.modules.programmer.ProgrammerModule;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.items.ProgramCardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;

public class ProgrammerTileEntity
extends GenericTileEntity {
    public static final int SLOT_CARD = 0;
    public static final int SLOT_DUMMY = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).box(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)VariousModule.PROGRAM_CARD.get())}).in().out(), 0, 91, 136, 1, 1).box(SlotDefinition.generic(), 1, -1000, -1000, 1, 1).playerSlots(91, 157));
    private final GenericItemHandler items = GenericItemHandler.basic((GenericTileEntity)this, CONTAINER_FACTORY);
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<ProgrammerTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<ProgrammerTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Programmer").containerSupplier(DefaultContainerProvider.container(ProgrammerModule.PROGRAMMER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)tile)).itemHandler(() -> tile.items).setupSync((GenericTileEntity)tile);

    public ProgrammerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ProgrammerModule.PROGRAMMER.be().get(), pos, state);
        this.items.setStackInSlot(1, new ItemStack((ItemLike)VariousModule.PROGRAM_CARD.get()));
    }

    public GenericItemHandler getItems() {
        return this.items;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.items.save(tag, "items", provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items.load(tag, "items", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }

    public void setPowerInput(int powered) {
        byte p = this.powerLevel;
        super.setPowerInput(powered);
        if (p != this.powerLevel && this.powerLevel > 0) {
            ItemStack dummy = this.items.getStackInSlot(1);
            if (dummy.isEmpty()) {
                return;
            }
            ItemStack card = this.items.getStackInSlot(0);
            if (card.isEmpty()) {
                return;
            }
            ProgramCardInstance instance = (ProgramCardInstance)dummy.get((DataComponentType)VariousModule.PROGRAM_CARD_DATA.get());
            if (instance == null) {
                return;
            }
            ProgramCardItem.setCardName(card, ProgramCardItem.getCardName(dummy));
            card.set((DataComponentType)VariousModule.PROGRAM_CARD_DATA.get(), (Object)instance);
        }
    }
}

