/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class GfxOpText
extends GfxOp {
    private int x;
    private int y;
    private String text;
    private int color;
    public static final Codec<GfxOpText> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("x").forGetter(o -> (byte)o.x), (App)Codec.BYTE.fieldOf("y").forGetter(o -> (byte)o.y), (App)Codec.STRING.fieldOf("text").forGetter(o -> o.text), (App)Codec.INT.fieldOf("color").forGetter(o -> o.color)).apply((Applicative)instance, (x, y, text, color) -> new GfxOpText(x.byteValue(), y.byteValue(), (String)text, (int)color)));
    public static final StreamCodec<RegistryFriendlyByteBuf, GfxOpText> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.x, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.y, (StreamCodec)ByteBufCodecs.STRING_UTF8, o -> o.text, (StreamCodec)ByteBufCodecs.INT, o -> o.color, (x, y, text, color) -> new GfxOpText(x.byteValue(), y.byteValue(), (String)text, (int)color));

    public GfxOpText() {
    }

    public GfxOpText(int x, int y, String text, int color) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.color = color;
    }

    @Override
    public void render(GuiGraphics graphics, MultiBufferSource buffer) {
        RenderHelper.renderText((Font)Minecraft.getInstance().font, (String)this.text, (int)this.x, (int)this.y, (int)this.color, (PoseStack)graphics.pose(), (MultiBufferSource)buffer, (int)0xF000F0);
    }

    @Override
    public GfxOpType getType() {
        return GfxOpType.OP_TEXT;
    }

    @Override
    protected void readFromNBTInternal(CompoundTag tag) {
        this.x = tag.getByte("x");
        this.y = tag.getByte("y");
        this.text = tag.getString("text");
        this.color = tag.getInt("color");
    }

    @Override
    protected void writeToNBTInternal(CompoundTag tag) {
        tag.putByte("x", (byte)this.x);
        tag.putByte("y", (byte)this.y);
        tag.putString("text", this.text);
        tag.putInt("color", this.color);
    }

    @Override
    protected void readFromBufInternal(FriendlyByteBuf buf) {
        this.x = buf.readByte();
        this.y = buf.readByte();
        this.text = buf.readUtf(Short.MAX_VALUE);
        this.color = buf.readInt();
    }

    @Override
    protected void writeToBufInternal(FriendlyByteBuf buf) {
        buf.writeByte(this.x);
        buf.writeByte(this.y);
        buf.writeUtf(this.text);
        buf.writeInt(this.color);
    }
}

