/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class GfxOpLine
extends GfxOp {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int color;
    public static final Codec<GfxOpLine> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("x1").forGetter(o -> (byte)o.x1), (App)Codec.BYTE.fieldOf("y1").forGetter(o -> (byte)o.y1), (App)Codec.BYTE.fieldOf("x2").forGetter(o -> (byte)o.x2), (App)Codec.BYTE.fieldOf("y2").forGetter(o -> (byte)o.y2), (App)Codec.INT.fieldOf("color").forGetter(o -> o.color)).apply((Applicative)instance, (x1, y1, x2, y2, color) -> new GfxOpLine(x1.byteValue(), y1.byteValue(), x2.byteValue(), y2.byteValue(), (int)color)));
    public static final StreamCodec<RegistryFriendlyByteBuf, GfxOpLine> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.x1, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.y1, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.x2, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.y2, (StreamCodec)ByteBufCodecs.INT, o -> o.color, (x1, y1, x2, y2, color) -> new GfxOpLine(x1.byteValue(), y1.byteValue(), x2.byteValue(), y2.byteValue(), (int)color));

    public GfxOpLine() {
    }

    public GfxOpLine(int x1, int y1, int x2, int y2, int color) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
    }

    @Override
    public void render(GuiGraphics graphics, MultiBufferSource buffer) {
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.getBuffer(CustomRenderTypes.OVERLAY_LINES);
        RenderHelper.line((VertexConsumer)builder, (PoseStack)graphics.pose(), (float)this.x1, (float)this.y1, (float)0.0f, (float)this.x2, (float)this.y2, (float)0.0f, (float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public GfxOpType getType() {
        return GfxOpType.OP_LINE;
    }

    @Override
    protected void readFromNBTInternal(CompoundTag tag) {
        this.x1 = tag.getByte("x1");
        this.y1 = tag.getByte("y1");
        this.x2 = tag.getByte("x2");
        this.y2 = tag.getByte("y2");
        this.color = tag.getInt("color");
    }

    @Override
    protected void writeToNBTInternal(CompoundTag tag) {
        tag.putByte("x1", (byte)this.x1);
        tag.putByte("y1", (byte)this.y1);
        tag.putByte("x2", (byte)this.x2);
        tag.putByte("y2", (byte)this.y2);
        tag.putInt("color", this.color);
    }

    @Override
    protected void readFromBufInternal(FriendlyByteBuf buf) {
        this.x1 = buf.readByte();
        this.y1 = buf.readByte();
        this.x2 = buf.readByte();
        this.y2 = buf.readByte();
        this.color = buf.readInt();
    }

    @Override
    protected void writeToBufInternal(FriendlyByteBuf buf) {
        buf.writeByte(this.x1);
        buf.writeByte(this.y1);
        buf.writeByte(this.x2);
        buf.writeByte(this.y2);
        buf.writeInt(this.color);
    }
}

