/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpText;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public abstract class GfxOp {
    public static final Codec<GfxOp> CODEC = Codec.of((Encoder)new Encoder<GfxOp>(){

        public <T> DataResult<T> encode(GfxOp input, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            builder.add("type", ops.createInt(input.getType().ordinal()));
            return switch (input.getType()) {
                default -> throw new MatchException(null, null);
                case GfxOpType.OP_BOX -> GfxOpBox.CODEC.encodeStart(ops, (Object)((GfxOpBox)input)).flatMap(d -> {
                    builder.add("data", d);
                    return builder.build(prefix);
                });
                case GfxOpType.OP_LINE -> GfxOpLine.CODEC.encodeStart(ops, (Object)((GfxOpLine)input)).flatMap(d -> {
                    builder.add("data", d);
                    return builder.build(prefix);
                });
                case GfxOpType.OP_TEXT -> GfxOpText.CODEC.encodeStart(ops, (Object)((GfxOpText)input)).flatMap(d -> {
                    builder.add("data", d);
                    return builder.build(prefix);
                });
            };
        }
    }, (Decoder)new Decoder<GfxOp>(){

        public <T> DataResult<Pair<GfxOp, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> {
                Object typeElem = map.get("type");
                if (typeElem == null) {
                    return DataResult.error(() -> "Missing 'type' for GfxOp");
                }
                DataResult typeRes = ops.getNumberValue(typeElem).map(Number::intValue);
                return typeRes.flatMap(t -> {
                    GfxOpType[] values = GfxOpType.values();
                    if (t < 0 || t >= values.length) {
                        return DataResult.error(() -> "Invalid GfxOp type: " + t);
                    }
                    Object dataElem = map.get("data");
                    if (dataElem == null) {
                        return DataResult.error(() -> "Missing 'data' for GfxOp");
                    }
                    GfxOpType type = values[t];
                    return switch (type) {
                        default -> throw new MatchException(null, null);
                        case GfxOpType.OP_BOX -> GfxOpBox.CODEC.decode(ops, dataElem).map(p -> Pair.of((Object)((GfxOp)p.getFirst()), (Object)ops.empty()));
                        case GfxOpType.OP_LINE -> GfxOpLine.CODEC.decode(ops, dataElem).map(p -> Pair.of((Object)((GfxOp)p.getFirst()), (Object)ops.empty()));
                        case GfxOpType.OP_TEXT -> GfxOpText.CODEC.decode(ops, dataElem).map(p -> Pair.of((Object)((GfxOp)p.getFirst()), (Object)ops.empty()));
                    };
                });
            });
        }
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, GfxOp> STREAM_CODEC = StreamCodec.of((buf, op) -> {
        buf.writeByte(op.getType().ordinal());
        switch (op.getType()) {
            case OP_BOX: {
                GfxOpBox.STREAM_CODEC.encode(buf, (Object)((GfxOpBox)op));
                break;
            }
            case OP_LINE: {
                GfxOpLine.STREAM_CODEC.encode(buf, (Object)((GfxOpLine)op));
                break;
            }
            case OP_TEXT: {
                GfxOpText.STREAM_CODEC.encode(buf, (Object)((GfxOpText)op));
            }
        }
    }, buf -> {
        byte ord = (Byte)ByteBufCodecs.BYTE.decode(buf);
        GfxOpType type = GfxOpType.values()[ord];
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GfxOpType.OP_BOX -> (GfxOpBox)GfxOpBox.STREAM_CODEC.decode(buf);
            case GfxOpType.OP_LINE -> (GfxOpLine)GfxOpLine.STREAM_CODEC.decode(buf);
            case GfxOpType.OP_TEXT -> (GfxOpText)GfxOpText.STREAM_CODEC.decode(buf);
        };
    });

    public abstract void render(GuiGraphics var1, MultiBufferSource var2);

    public abstract GfxOpType getType();

    public String getOpName() {
        return switch (this.getType()) {
            default -> throw new MatchException(null, null);
            case GfxOpType.OP_BOX -> "box";
            case GfxOpType.OP_LINE -> "line";
            case GfxOpType.OP_TEXT -> "text";
        };
    }

    public static GfxOp readFromNBT(CompoundTag tag) {
        GfxOpType type = GfxOpType.values()[tag.getByte("type")];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromNBTInternal(tag);
        return op;
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putByte("type", (byte)this.getType().ordinal());
        this.writeToNBTInternal(tag);
        return tag;
    }

    protected abstract void readFromNBTInternal(CompoundTag var1);

    protected abstract void writeToNBTInternal(CompoundTag var1);

    public static GfxOp readFromBuf(FriendlyByteBuf buf) {
        GfxOpType type = GfxOpType.values()[buf.readByte()];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromBufInternal(buf);
        return op;
    }

    private static GfxOp createGfxOp(GfxOpType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GfxOpType.OP_BOX -> new GfxOpBox();
            case GfxOpType.OP_LINE -> new GfxOpLine();
            case GfxOpType.OP_TEXT -> new GfxOpText();
        };
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeByte(this.getType().ordinal());
        this.writeToBufInternal(buf);
    }

    protected abstract void readFromBufInternal(FriendlyByteBuf var1);

    protected abstract void writeToBufInternal(FriendlyByteBuf var1);
}

