/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGraphicsReady(BlockPos pos, Map<String, GfxOp> gfxOps, List<String> orderedOps) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"graphics_ready");
    public static final CustomPacketPayload.Type<PacketGraphicsReady> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGraphicsReady> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBlockPos(packet.pos);
        buf.writeInt(packet.gfxOps.size());
        packet.gfxOps.forEach((key, value) -> {
            buf.writeUtf(key);
            value.writeToBuf((FriendlyByteBuf)buf);
        });
        buf.writeInt(packet.orderedOps.size());
        packet.orderedOps.forEach(arg_0 -> ((RegistryFriendlyByteBuf)buf).writeUtf(arg_0));
    }, buf -> {
        BlockPos pos = buf.readBlockPos();
        int size = buf.readInt();
        HashMap<String, GfxOp> gfxOps = new HashMap<String, GfxOp>(size);
        for (int i = 0; i < size; ++i) {
            String key = buf.readUtf(Short.MAX_VALUE);
            GfxOp gfxOp = GfxOp.readFromBuf((FriendlyByteBuf)buf);
            gfxOps.put(key, gfxOp);
        }
        size = buf.readInt();
        ArrayList<String> orderedOps = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            orderedOps.add(buf.readUtf(Short.MAX_VALUE));
        }
        return new PacketGraphicsReady(pos, gfxOps, orderedOps);
    });

    public static PacketGraphicsReady create(ProcessorTileEntity processor) {
        return new PacketGraphicsReady(processor.getBlockPos(), processor.getGfxOps(), processor.getOrderedOps());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().getBlockEntity(this.pos);
            if (te instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.setClientOrderedGfx(this.gfxOps, this.orderedOps);
            }
        });
    }
}

