/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.running;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.control.code.IOpcodeRunnable;
import mcjty.rftoolsbase.api.control.machines.IProgram;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.modules.processor.logic.running.CpuCore;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class RunningProgram
implements IProgram {
    public static boolean DEBUG = false;
    private final int cardIndex;
    private int current = 0;
    private int eventIndex = 0;
    private String ticket = null;
    private String lock = null;
    private int delay = 0;
    private boolean dead = false;
    private IParameter lastValue;
    private CpuCore core;
    private final List<FlowStack> loopStack = new ArrayList<FlowStack>();
    private List<CompiledOpcode> opcodeCache = null;

    public RunningProgram(int cardIndex) {
        this.cardIndex = cardIndex;
    }

    public void startFromEvent(CompiledEvent event) {
        this.current = event.index();
        this.eventIndex = event.index();
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setCore(CpuCore core) {
        this.core = core;
    }

    public CpuCore getCore() {
        return this.core;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public void setCraftTicket(@Nullable String craftId) {
        this.ticket = craftId;
    }

    @Nullable
    public String getCraftTicket() {
        return this.ticket;
    }

    public boolean hasCraftTicket() {
        return this.ticket != null && !this.ticket.isEmpty();
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    public void killMe() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getCardIndex() {
        return this.cardIndex;
    }

    public void setLastValue(IParameter value) {
        this.lastValue = value;
    }

    public IParameter getLastValue() {
        return this.lastValue;
    }

    public CompiledOpcode getCurrentOpcode(ProcessorTileEntity processor) {
        return this.opcodes(processor).get(this.current);
    }

    public void pushLoopStack(int varIndex) {
        if (this.loopStack.size() >= (Integer)Config.maxStackSize.get()) {
            throw new ProgException(ExceptionType.EXCEPT_STACKOVERFLOW);
        }
        this.loopStack.add(new FlowStack(this.current, varIndex));
    }

    public void pushCall(int returnIndex) {
        if (this.loopStack.size() >= (Integer)Config.maxStackSize.get()) {
            throw new ProgException(ExceptionType.EXCEPT_STACKOVERFLOW);
        }
        this.loopStack.add(new FlowStack(returnIndex, null));
    }

    public void popLoopStack(ProcessorTileEntity processor) {
        if (this.loopStack.isEmpty()) {
            this.killMe();
        } else {
            FlowStack pair = this.loopStack.get(this.loopStack.size() - 1);
            this.current = pair.getCurrent();
            Integer varIdx = pair.getVar();
            this.loopStack.remove(this.loopStack.size() - 1);
            if (varIdx != null) {
                Parameter parameter = processor.getVariableAt(varIdx);
                int i = TypeConverters.convertToInt((IParameter)parameter);
                processor.setVariableInternal(this, varIdx, Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)(++i))).build());
            }
        }
    }

    public boolean run(ProcessorTileEntity processor) {
        if (this.delay > 0) {
            --this.delay;
            return false;
        }
        if (this.lock != null) {
            if (processor.testLock(this.lock)) {
                return false;
            }
            this.lock = null;
        }
        try {
            IOpcodeRunnable.OpcodeResult result;
            CompiledOpcode opcode = this.opcodes(processor).get(this.current);
            if (DEBUG) {
                System.out.println(opcode.getOpcode());
            }
            if ((result = opcode.run(processor, this)) == IOpcodeRunnable.OpcodeResult.POSITIVE) {
                this.current = opcode.getPrimaryIndex();
            } else if (result == IOpcodeRunnable.OpcodeResult.NEGATIVE) {
                this.current = opcode.getSecondaryIndex();
            }
        }
        catch (ProgException e) {
            throw e;
        }
        catch (Exception e) {
            LogManager.getLogger().log(Level.ERROR, "Opcode failed with: ", (Throwable)e);
            throw new ProgException(ExceptionType.EXCEPT_INTERNALERROR);
        }
        return true;
    }

    private List<CompiledOpcode> opcodes(ProcessorTileEntity processor) {
        if (this.opcodeCache == null) {
            CompiledCard card = processor.getCompiledCard(this.cardIndex);
            this.opcodeCache = card.getOpcodes();
        }
        return this.opcodeCache;
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("card", this.cardIndex);
        tag.putInt("current", this.current);
        tag.putInt("event", this.eventIndex);
        tag.putInt("delay", this.delay);
        tag.putBoolean("dead", this.dead);
        if (this.ticket != null) {
            tag.putString("ticket", this.ticket);
        }
        if (this.lock != null) {
            tag.putString("lock", this.lock);
        }
        if (this.lastValue != null) {
            CompoundTag varTag = new CompoundTag();
            varTag.putInt("type", this.lastValue.getParameterType().ordinal());
            ParameterTypeTools.writeToNBT(varTag, this.lastValue.getParameterType(), this.lastValue.getParameterValue(), provider);
            tag.put("lastvar", (Tag)varTag);
        }
        if (!this.loopStack.isEmpty()) {
            ListTag loopList = new ListTag();
            for (FlowStack pair : this.loopStack) {
                CompoundTag t = new CompoundTag();
                t.putInt("index", pair.getCurrent());
                t.putInt("var", pair.getVar() == null ? -1 : pair.getVar());
                loopList.add((Object)t);
            }
            tag.put("loopStack", (Tag)loopList);
        }
    }

    public static RunningProgram readFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        if (!tag.contains("card")) {
            return null;
        }
        int cardIndex = tag.getInt("card");
        RunningProgram program = new RunningProgram(cardIndex);
        program.setCurrent(tag.getInt("current"));
        program.eventIndex = tag.getInt("event");
        program.setDelay(tag.getInt("delay"));
        program.dead = tag.getBoolean("dead");
        if (tag.contains("ticket")) {
            program.ticket = tag.getString("ticket");
        }
        if (tag.contains("lock")) {
            program.lock = tag.getString("lock");
        }
        if (tag.contains("lastvar")) {
            CompoundTag varTag = tag.getCompound("lastvar");
            int t = varTag.getInt("type");
            ParameterType type = ParameterType.values()[t];
            program.lastValue = Parameter.builder().type(type).value(ParameterTypeTools.readFromNBT(varTag, type, provider)).build();
        }
        if (tag.contains("loopStack")) {
            program.loopStack.clear();
            ListTag loopList = tag.getList("loopStack", 10);
            for (int i = 0; i < loopList.size(); ++i) {
                CompoundTag t = loopList.getCompound(i);
                int var = tag.getInt("var");
                program.loopStack.add(new FlowStack(tag.getInt("index"), var == -1 ? null : Integer.valueOf(var)));
            }
        }
        return program;
    }

    private static class FlowStack {
        private final int current;
        private final Integer var;

        public FlowStack(int current, Integer var) {
            this.current = current;
            this.var = var;
        }

        public int getCurrent() {
            return this.current;
        }

        public Integer getVar() {
            return this.var;
        }
    }
}

