/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Functions;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public class ParameterTypeTools {
    public static String stringRepresentation(ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            return "V:" + value.getVariableIndex();
        }
        if (value.isFunction()) {
            return "F:" + value.getFunction().getName();
        }
        if (value.getValue() == null) {
            return "";
        }
        return ParameterTypeTools.stringRepresentationInternal(type, value.getValue());
    }

    private static String stringRepresentationInternal(ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                return (String)value;
            }
            case PAR_INTEGER: {
                return Integer.toString((Integer)value);
            }
            case PAR_LONG: {
                return Long.toString((Long)value);
            }
            case PAR_FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case PAR_NUMBER: {
                String s = TypeConverters.castNumberToString(value);
                return s + " (" + TypeConverters.getNumberType(value) + ")";
            }
            case PAR_SIDE: {
                return ((BlockSide)value).getStringRepresentation();
            }
            case PAR_BOOLEAN: {
                return (Boolean)value != false ? "true" : "false";
            }
            case PAR_INVENTORY: {
                return ((Inventory)value).getStringRepresentation();
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                return StringUtils.left((String)itemStack.getHoverName().getString(), (int)10);
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                return StringUtils.left((String)fluidStack.getHoverName().getString(), (int)10);
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                return exception.getCode();
            }
            case PAR_TUPLE: {
                return value.toString();
            }
            case PAR_VECTOR: {
                return "[" + ((List)value).size() + "]";
            }
        }
        return "?";
    }

    public static JsonElement writeToJson(ParameterType type, ParameterValue value) {
        JsonObject jsonObject = new JsonObject();
        if (value.isVariable()) {
            jsonObject.add("var", (JsonElement)new JsonPrimitive((Number)value.getVariableIndex()));
        } else if (value.isFunction()) {
            jsonObject.add("fun", (JsonElement)new JsonPrimitive(value.getFunction().getId()));
        } else if (value.getValue() == null) {
            jsonObject.add("null", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        } else {
            ParameterTypeTools.writeToJsonInternal(jsonObject, type, value.getValue());
        }
        return jsonObject;
    }

    public static ParameterValue readFromJson(ParameterType type, JsonObject object) {
        if (object.has("var")) {
            return ParameterValue.variable((int)object.get("var").getAsInt());
        }
        if (object.has("fun")) {
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(object.get("fun").getAsString()));
        }
        if (object.has("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromJsonInternal(object, type);
    }

    public static void writeToNBT(CompoundTag tag, ParameterType type, ParameterValue value, HolderLookup.Provider provider) {
        if (value.isVariable()) {
            tag.putInt("varIdx", value.getVariableIndex());
        } else if (value.isFunction()) {
            tag.putString("funId", value.getFunction().getId());
        } else if (value.getValue() == null) {
            tag.putBoolean("null", true);
        } else {
            ParameterTypeTools.writeToNBTInternal(tag, type, value.getValue(), provider);
        }
    }

    public static ParameterValue readFromNBT(CompoundTag tag, ParameterType type, HolderLookup.Provider provider) {
        if (tag.contains("varIdx")) {
            return ParameterValue.variable((int)tag.getInt("varIdx"));
        }
        if (tag.contains("funId")) {
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(tag.getString("funId")));
        }
        if (tag.contains("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromNBTInternal(tag, type, provider);
    }

    private static ParameterValue readFromNBTInternal(CompoundTag tag, ParameterType type, HolderLookup.Provider provider) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant((Object)tag.getString("v"));
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Object)tag.getInt("v"));
            }
            case PAR_LONG: {
                return ParameterValue.constant((Object)tag.getLong("v"));
            }
            case PAR_FLOAT: {
                return ParameterValue.constant((Object)Float.valueOf(tag.getFloat("v")));
            }
            case PAR_NUMBER: {
                if (tag.contains("v")) {
                    return ParameterValue.constant((Object)tag.getInt("v"));
                }
                if (tag.contains("l")) {
                    return ParameterValue.constant((Object)tag.getLong("l"));
                }
                if (tag.contains("f")) {
                    return ParameterValue.constant((Object)Float.valueOf(tag.getFloat("f")));
                }
                if (!tag.contains("d")) break;
                return ParameterValue.constant((Object)tag.getDouble("d"));
            }
            case PAR_SIDE: {
                int v = tag.getInt("v");
                Direction facing = v == -1 ? null : Direction.values()[v];
                String node = tag.getString("node");
                return ParameterValue.constant((Object)new BlockSide(node, facing));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Object)tag.getBoolean("v"));
            }
            case PAR_INVENTORY: {
                Direction side = Direction.values()[tag.getInt("side")];
                String name = null;
                Direction intSide = null;
                if (tag.contains("nodeName")) {
                    name = tag.getString("nodeName");
                }
                if (tag.contains("intSide")) {
                    intSide = Direction.values()[tag.getInt("intSide")];
                }
                return ParameterValue.constant((Object)new Inventory(name, side, intSide));
            }
            case PAR_ITEM: {
                if (tag.contains("item")) {
                    CompoundTag tc = tag.getCompound("item");
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tc);
                    if (stack.getCount() == 0) {
                        stack.setCount(1);
                    }
                    return ParameterValue.constant((Object)stack);
                }
                return ParameterValue.constant((Object)ItemStack.EMPTY);
            }
            case PAR_FLUID: {
                if (tag.contains("fluid")) {
                    CompoundTag tc = tag.getCompound("fluid");
                    FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tc);
                    return ParameterValue.constant((Object)stack);
                }
                return ParameterValue.constant(null);
            }
            case PAR_EXCEPTION: {
                String code = tag.getString("code");
                return ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(code)));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant((Object)new Tuple(tag.getInt("x"), tag.getInt("y")));
            }
            case PAR_VECTOR: {
                ListTag array = tag.getList("vector", 10);
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (int i = 0; i < array.size(); ++i) {
                    vector.add(ParameterTools.readFromNBT(array.getCompound(i), provider));
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return ParameterValue.constant(null);
    }

    private static void writeToNBTInternal(CompoundTag tag, ParameterType type, Object value, HolderLookup.Provider provider) {
        switch (type) {
            case PAR_STRING: {
                tag.putString("v", (String)value);
                break;
            }
            case PAR_INTEGER: {
                tag.putInt("v", ((Integer)value).intValue());
                break;
            }
            case PAR_LONG: {
                tag.putLong("v", ((Long)value).longValue());
                break;
            }
            case PAR_FLOAT: {
                tag.putFloat("v", ((Float)value).floatValue());
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    tag.putInt("v", ((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    tag.putLong("l", ((Long)value).longValue());
                    break;
                }
                if (value instanceof Float) {
                    tag.putFloat("f", ((Float)value).floatValue());
                    break;
                }
                if (!(value instanceof Double)) break;
                tag.putDouble("d", ((Double)value).doubleValue());
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                tag.putInt("v", side.getSide() == null ? -1 : side.getSide().ordinal());
                tag.putString("node", side.getNodeName() == null ? "" : side.getNodeName());
                break;
            }
            case PAR_BOOLEAN: {
                tag.putBoolean("v", ((Boolean)value).booleanValue());
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                if (inv.getNodeName() != null) {
                    tag.putString("nodeName", inv.getNodeName());
                }
                tag.putInt("side", inv.getSide().ordinal());
                if (inv.getIntSide() == null) break;
                tag.putInt("intSide", inv.getIntSide().ordinal());
                break;
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                Tag tc = itemStack.save(provider);
                tag.put("item", tc);
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                Tag fluidTc = fluidStack.save(provider);
                tag.put("fluid", fluidTc);
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                tag.putString("code", exception.getCode());
                break;
            }
            case PAR_TUPLE: {
                tag.putInt("x", ((Tuple)value).getX());
                tag.putInt("y", ((Tuple)value).getY());
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                ListTag list = new ListTag();
                for (Parameter p : vector) {
                    list.add((Object)ParameterTools.writeToNBT(p, provider));
                }
                tag.put("vector", (Tag)list);
            }
        }
    }

    private static void writeToJsonInternal(JsonObject object, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                object.add("v", (JsonElement)new JsonPrimitive((String)value));
                break;
            }
            case PAR_INTEGER: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                break;
            }
            case PAR_LONG: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                break;
            }
            case PAR_FLOAT: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                    break;
                }
                if (value instanceof Long) {
                    object.add("l", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                    break;
                }
                if (value instanceof Float) {
                    object.add("f", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                    break;
                }
                if (!(value instanceof Double)) break;
                object.add("d", (JsonElement)new JsonPrimitive((Number)((Double)value)));
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                if (side.getSide() != null) {
                    object.add("side", (JsonElement)new JsonPrimitive(side.getSide().getSerializedName()));
                }
                if (side.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(side.getNodeName()));
                break;
            }
            case PAR_BOOLEAN: {
                object.add("v", (JsonElement)new JsonPrimitive((Boolean)value));
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                object.add("side", (JsonElement)new JsonPrimitive(inv.getSide().getSerializedName()));
                if (inv.getIntSide() != null) {
                    object.add("intside", (JsonElement)new JsonPrimitive(inv.getIntSide().getSerializedName()));
                }
                if (inv.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(inv.getNodeName()));
                break;
            }
            case PAR_ITEM: {
                ItemStack item = (ItemStack)value;
                ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)item).resultOrPartial(System.err::println).ifPresent(obj -> object.add("item", obj));
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                FluidStack.OPTIONAL_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)fluidStack).resultOrPartial(System.err::println).ifPresent(obj -> object.add("fluid", obj));
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                object.add("code", (JsonElement)new JsonPrimitive(exception.getCode()));
                break;
            }
            case PAR_TUPLE: {
                object.add("x", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getX()));
                object.add("y", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getY()));
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                JsonArray array = new JsonArray();
                for (Parameter p : vector) {
                    array.add(ParameterTools.getJsonElement(p));
                }
                object.add("vector", (JsonElement)array);
            }
        }
    }

    private static ParameterValue readFromJsonInternal(JsonObject object, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant((Object)object.get("v").getAsString());
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Object)object.get("v").getAsInt());
            }
            case PAR_LONG: {
                return ParameterValue.constant((Object)object.get("v").getAsLong());
            }
            case PAR_FLOAT: {
                return ParameterValue.constant((Object)Float.valueOf(object.get("v").getAsFloat()));
            }
            case PAR_NUMBER: {
                if (object.has("v")) {
                    return ParameterValue.constant((Object)object.get("v").getAsInt());
                }
                if (object.has("l")) {
                    return ParameterValue.constant((Object)object.get("l").getAsLong());
                }
                if (object.has("f")) {
                    return ParameterValue.constant((Object)Float.valueOf(object.get("f").getAsFloat()));
                }
                if (!object.has("d")) break;
                return ParameterValue.constant((Object)object.get("d").getAsDouble());
            }
            case PAR_SIDE: {
                Direction side = object.has("side") ? Direction.byName((String)object.get("side").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant((Object)new BlockSide(node, side));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Object)object.get("v").getAsBoolean());
            }
            case PAR_INVENTORY: {
                Direction side = Direction.byName((String)object.get("side").getAsString());
                Direction intSide = object.has("intside") ? Direction.byName((String)object.get("intside").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant((Object)new Inventory(node, side, intSide));
            }
            case PAR_ITEM: {
                JsonElement itemObj = object.get("item");
                return ItemStack.OPTIONAL_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)itemObj).result().map(ParameterValue::constant).orElseThrow(RuntimeException::new);
            }
            case PAR_FLUID: {
                JsonElement fluidObj = object.get("fluid");
                return ItemStack.OPTIONAL_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)fluidObj).result().map(ParameterValue::constant).orElseThrow(RuntimeException::new);
            }
            case PAR_EXCEPTION: {
                String code = object.get("code").getAsString();
                return ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(code)));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant((Object)new Tuple(object.get("x").getAsInt(), object.get("y").getAsInt()));
            }
            case PAR_VECTOR: {
                JsonArray array = object.get("vector").getAsJsonArray();
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (JsonElement element : array) {
                    JsonObject job = element.getAsJsonObject();
                    ParameterType t = ParameterType.getByName((String)job.get("type").getAsString());
                    vector.add(Parameter.builder().type(t).value(ParameterTypeTools.readFromJson(t, job)).build());
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return null;
    }
}

