/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum Connection implements StringRepresentable
{
    UP("U"),
    DOWN("D"),
    LEFT("L"),
    RIGHT("R"),
    UP_NEG("u"),
    DOWN_NEG("d"),
    LEFT_NEG("l"),
    RIGHT_NEG("r");

    private final String id;
    public static final Codec<Connection> CODEC;
    public static final StreamCodec<FriendlyByteBuf, Connection> STREAM_CODEC;
    private static final Map<String, Connection> ID_TO_CONNECTION;

    private Connection(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static Connection getConnection(String id) {
        return ID_TO_CONNECTION.get(id);
    }

    public boolean isPrimary() {
        return this.id.equals(this.id.toUpperCase());
    }

    public GridPos offset(GridPos coordinate) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 4 -> GridPos.pos(coordinate.x(), coordinate.y() - 1);
            case 1, 5 -> GridPos.pos(coordinate.x(), coordinate.y() + 1);
            case 2, 6 -> GridPos.pos(coordinate.x() - 1, coordinate.y());
            case 3, 7 -> GridPos.pos(coordinate.x() + 1, coordinate.y());
        };
    }

    public Connection getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> UP_NEG;
            case 1 -> DOWN_NEG;
            case 2 -> LEFT_NEG;
            case 3 -> RIGHT_NEG;
            case 4 -> UP;
            case 5 -> DOWN;
            case 6 -> LEFT;
            case 7 -> RIGHT;
        };
    }

    public String getSerializedName() {
        return this.id;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Connection::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Connection.class);
        ID_TO_CONNECTION = new HashMap<String, Connection>();
        for (Connection connection : Connection.values()) {
            ID_TO_CONNECTION.put(connection.getId(), connection);
        }
    }
}

