/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolscontrol.modules.processor.util.WatchInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ProcessorCoreData(Set<String> locks, List<Parameter> variables, List<WatchInfo> watchInfos, List<CoreEntry> cores, int tickCount, String lastException, long lastExceptionTime) {
    public static final ProcessorCoreData DEFAULT = new ProcessorCoreData(Set.of(), List.of(), List.of(), List.of(), 0, "", 0L);
    public static final Codec<ProcessorCoreData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("locks").forGetter(data -> new ArrayList<String>(data.locks())), (App)Parameter.CODEC.listOf().fieldOf("variables").forGetter(ProcessorCoreData::variables), (App)WatchInfo.CODEC.listOf().fieldOf("watch_infos").forGetter(ProcessorCoreData::watchInfos), (App)CoreEntry.CODEC.listOf().fieldOf("cores").forGetter(ProcessorCoreData::cores), (App)Codec.INT.fieldOf("tickCount").forGetter(ProcessorCoreData::tickCount), (App)Codec.STRING.fieldOf("lastException").forGetter(ProcessorCoreData::lastException), (App)Codec.LONG.fieldOf("lastExceptionTime").forGetter(ProcessorCoreData::lastExceptionTime)).apply((Applicative)instance, (locks, variables, watchInfos, cores, tickCount, lastException, lastExceptionTime) -> new ProcessorCoreData((Set<String>)new LinkedHashSet<String>((Collection<String>)locks), (List<Parameter>)variables, (List<WatchInfo>)watchInfos, (List<CoreEntry>)cores, (int)tickCount, (String)lastException, (long)lastExceptionTime)));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProcessorCoreData> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), data -> new ArrayList<String>(data.locks()), (StreamCodec)Parameter.STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), ProcessorCoreData::variables, (StreamCodec)WatchInfo.STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), ProcessorCoreData::watchInfos, (StreamCodec)CoreEntry.STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), ProcessorCoreData::cores, (StreamCodec)ByteBufCodecs.INT, ProcessorCoreData::tickCount, (StreamCodec)ByteBufCodecs.STRING_UTF8, ProcessorCoreData::lastException, (StreamCodec)ByteBufCodecs.VAR_LONG, ProcessorCoreData::lastExceptionTime, (locks, variables, watchInfos, cores, tickCount, lastException, lastExceptionTime) -> new ProcessorCoreData((Set<String>)new LinkedHashSet<String>((Collection<String>)locks), (List<Parameter>)variables, (List<WatchInfo>)watchInfos, (List<CoreEntry>)cores, (int)tickCount, (String)lastException, (long)lastExceptionTime));

    public ProcessorCoreData {
        Objects.requireNonNull(locks, "locks cannot be null");
        Objects.requireNonNull(variables, "variables cannot be null");
        Objects.requireNonNull(watchInfos, "watchInfos cannot be null");
        Objects.requireNonNull(cores, "cores cannot be null");
        locks = ProcessorCoreData.immutableLinkedSet(locks);
        variables = ProcessorCoreData.immutableListAllowNulls(variables);
        watchInfos = ProcessorCoreData.immutableListAllowNulls(watchInfos);
        cores = ProcessorCoreData.immutableListNoNulls(cores);
    }

    public ProcessorCoreData withLocks(Set<String> locks) {
        return new ProcessorCoreData(locks, this.variables, this.watchInfos, this.cores, this.tickCount, this.lastException, this.lastExceptionTime);
    }

    public ProcessorCoreData withVariables(List<Parameter> variables) {
        return new ProcessorCoreData(this.locks, variables, this.watchInfos, this.cores, this.tickCount, this.lastException, this.lastExceptionTime);
    }

    public ProcessorCoreData withWatchInfos(List<WatchInfo> watchInfos) {
        return new ProcessorCoreData(this.locks, this.variables, watchInfos, this.cores, this.tickCount, this.lastException, this.lastExceptionTime);
    }

    public ProcessorCoreData withCores(List<CoreEntry> cores) {
        return new ProcessorCoreData(this.locks, this.variables, this.watchInfos, cores, this.tickCount, this.lastException, this.lastExceptionTime);
    }

    public ProcessorCoreData withTickCount(int tickCount) {
        return new ProcessorCoreData(this.locks, this.variables, this.watchInfos, this.cores, tickCount, this.lastException, this.lastExceptionTime);
    }

    public ProcessorCoreData withLastException(String lastException) {
        return new ProcessorCoreData(this.locks, this.variables, this.watchInfos, this.cores, this.tickCount, lastException, this.lastExceptionTime);
    }

    public ProcessorCoreData withLastExceptionTime(long lastExceptionTime) {
        return new ProcessorCoreData(this.locks, this.variables, this.watchInfos, this.cores, this.tickCount, this.lastException, lastExceptionTime);
    }

    public Parameter variableAt(int index) {
        if (index < 0 || index >= this.variables.size()) {
            return null;
        }
        return this.variables.get(index);
    }

    public ProcessorCoreData withVariable(int index, Parameter value) {
        boolean requiresResize;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        ArrayList<Parameter> copy = new ArrayList<Parameter>(this.variables);
        boolean bl = requiresResize = index >= copy.size();
        if (!requiresResize && Objects.equals(copy.get(index), value)) {
            return this;
        }
        while (copy.size() <= index) {
            copy.add(null);
        }
        copy.set(index, value);
        return this.withVariables(copy);
    }

    public WatchInfo watchInfoAt(int index) {
        if (index < 0 || index >= this.watchInfos.size()) {
            return null;
        }
        return this.watchInfos.get(index);
    }

    public ProcessorCoreData withWatchInfo(int index, WatchInfo info) {
        boolean requiresResize;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        ArrayList<WatchInfo> copy = new ArrayList<WatchInfo>(this.watchInfos);
        boolean bl = requiresResize = index >= copy.size();
        if (!requiresResize && Objects.equals(copy.get(index), info)) {
            return this;
        }
        while (copy.size() <= index) {
            copy.add(null);
        }
        copy.set(index, info);
        return this.withWatchInfos(copy);
    }

    public boolean hasLock(String name) {
        return this.locks.contains(name);
    }

    public ProcessorCoreData withLockAdded(String name) {
        if (this.locks.contains(name)) {
            return this;
        }
        LinkedHashSet<String> copy = new LinkedHashSet<String>(this.locks);
        copy.add(name);
        return this.withLocks(copy);
    }

    public ProcessorCoreData withLockRemoved(String name) {
        if (!this.locks.contains(name)) {
            return this;
        }
        LinkedHashSet<String> copy = new LinkedHashSet<String>(this.locks);
        copy.remove(name);
        return this.withLocks(copy);
    }

    public CoreEntry coreAt(int index) {
        if (index < 0 || index >= this.cores.size()) {
            return null;
        }
        return this.cores.get(index);
    }

    public ProcessorCoreData withCore(int index, CoreEntry entry) {
        if (index < 0 || index >= this.cores.size()) {
            throw new IndexOutOfBoundsException("index out of bounds: " + index);
        }
        if (Objects.equals(this.cores.get(index), entry)) {
            return this;
        }
        Objects.requireNonNull(entry, "entry cannot be null");
        ArrayList<CoreEntry> copy = new ArrayList<CoreEntry>(this.cores);
        copy.set(index, entry);
        return this.withCores(copy);
    }

    private static <T> List<T> immutableListAllowNulls(List<T> source) {
        return Collections.unmodifiableList(new ArrayList<T>(source));
    }

    private static <T> List<T> immutableListNoNulls(List<T> source) {
        ArrayList<T> copy = new ArrayList<T>(source.size());
        for (T element : source) {
            copy.add(Objects.requireNonNull(element, "List element cannot be null"));
        }
        return Collections.unmodifiableList(copy);
    }

    private static <T> Set<T> immutableLinkedSet(Set<T> source) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(source));
    }

    public record CoreEntry(int tier) {
        public static final Codec<CoreEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tier").forGetter(CoreEntry::tier)).apply((Applicative)instance, CoreEntry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CoreEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CoreEntry::tier, CoreEntry::new);
    }
}

