/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.data;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum HudMode implements StringRepresentable
{
    OFF("Off"),
    LOG("Log"),
    DB("Db"),
    GFX("Gfx");

    private final String name;
    public static final Codec<HudMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, HudMode> STREAM_CODEC;

    private HudMode(String name) {
        this.name = name;
    }

    public static HudMode fromOrdinal(int ord) {
        HudMode[] values = HudMode.values();
        if (ord < 0 || ord >= values.length) {
            return OFF;
        }
        return values[ord];
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getName() {
        return this.name;
    }

    public static HudMode stringToMode(String name) {
        if ("Off".equals(name)) {
            return OFF;
        }
        if ("Log".equals(name)) {
            return LOG;
        }
        if ("Db".equals(name)) {
            return DB;
        }
        return GFX;
    }

    static {
        CODEC = StringRepresentable.fromEnum(HudMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(HudMode.class);
    }
}

