/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;

public record MultiTankData(List<FluidStack> fluids) {
    public static final Codec<MultiTankData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)FluidStack.OPTIONAL_CODEC).fieldOf("fluids").forGetter(MultiTankData::fluids)).apply((Applicative)instance, MultiTankData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MultiTankData> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), MultiTankData::fluids, MultiTankData::new);

    public static MultiTankData createDefault() {
        return new MultiTankData(MultiTankData.defaultFluids());
    }

    public MultiTankData withFluids(List<FluidStack> fluids) {
        return new MultiTankData(MultiTankData.copyFluids(fluids));
    }

    public static MultiTankData of(List<FluidStack> fluids) {
        return new MultiTankData(MultiTankData.copyFluids(fluids));
    }

    private static List<FluidStack> defaultFluids() {
        ArrayList<FluidStack> defaults = new ArrayList<FluidStack>(4);
        for (int i = 0; i < 4; ++i) {
            defaults.add(FluidStack.EMPTY);
        }
        return defaults;
    }

    private static List<FluidStack> copyFluids(List<FluidStack> fluids) {
        ArrayList<FluidStack> copy = new ArrayList<FluidStack>(4);
        for (int i = 0; i < 4; ++i) {
            FluidStack stack = i < fluids.size() ? fluids.get(i) : FluidStack.EMPTY;
            copy.add(stack.isEmpty() ? FluidStack.EMPTY : stack.copy());
        }
        return copy;
    }
}

