/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol;

import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.rftoolscontrol.compat.RFToolsStuff;
import mcjty.rftoolscontrol.modules.craftingstation.CraftingStationModule;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.programmer.ProgrammerModule;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import mcjty.rftoolscontrol.setup.ModSetup;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import mcjty.rftoolscontrol.setup.Registration;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="rftoolscontrol")
public class RFToolsControl {
    public static final String MODID = "rftoolscontrol";
    public static final ModSetup setup = new ModSetup();
    private final Modules modules = new Modules();
    public static RFToolsControl instance;

    public RFToolsControl(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        this.setupModules(bus, dist);
        RFToolsStuff.init();
        Config.register(mod, bus, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(setup::processIMC);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::onDataGen);
        bus.addListener(RFToolsCtrlMessages::registerMessages);
        bus.addListener(WorkbenchTileEntity::registerCapabilities);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        datagen.generate();
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new CraftingStationModule(bus));
        this.modules.register((IModule)new MultiTankModule(bus));
        this.modules.register((IModule)new ProcessorModule(bus));
        this.modules.register((IModule)new ProgrammerModule(bus));
        this.modules.register((IModule)new VariousModule(bus));
    }
}

