/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.client.command;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.portingdeadmods.stickit.client.render.tile.TESRPlacedItems;
import com.portingdeadmods.stickit.client.util.RenderUtils;
import com.portingdeadmods.stickit.common.command.IPlonkCommand;
import com.portingdeadmods.stickit.common.util.MatrixUtils;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CommandDumpRenderTypes
implements IPlonkCommand {
    private static final Logger LOG = LogManager.getLogger();
    private static final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    private static LinkedHashSet<ItemStackRef> getAllStacks() {
        LinkedHashSet<ItemStackRef> items = new LinkedHashSet<ItemStackRef>();
        Objects.requireNonNull((CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.SEARCH)).getDisplayItems().stream().map(ItemStackRef::new).forEach(items::add);
        return items;
    }

    private static String describeStack(ItemStack stack) {
        StringBuilder build = new StringBuilder();
        build.append(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
        Optional.of(stack.getTags()).ifPresent(build::append);
        return build.toString();
    }

    private static Stream<Map.Entry<String, String>> getRenderData(ItemStack stack) {
        BakedModel model = itemRenderer.getModel(stack, null, null, 0);
        ItemDisplayContext[] types = new ItemDisplayContext[]{ItemDisplayContext.FIXED, ItemDisplayContext.GUI};
        Map baseTransforms = Arrays.stream(types).collect(Collectors.toMap(type -> type.name().toLowerCase(Locale.ROOT), type -> new Matrix4f((Matrix4fc)RenderUtils.getModelTransformMatrix(model, type)), (a, b) -> b, LinkedHashMap::new));
        LinkedHashMap<String, Matrix4f> transforms = new LinkedHashMap<String, Matrix4f>();
        transforms.put("fixed->gui", MatrixUtils.difference((Matrix4f)baseTransforms.get("fixed"), (Matrix4f)baseTransforms.get("gui")));
        transforms.putAll(baseTransforms);
        return transforms.entrySet().stream().flatMap(kv -> {
            String transformName = (String)kv.getKey();
            return CommandDumpRenderTypes.describeTransform((Matrix4f)kv.getValue()).entrySet().stream().map(e -> new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)(transformName + "." + (String)e.getKey())), (String)e.getValue()));
        });
    }

    private static LinkedHashMap<String, String> describeTransform(Matrix4f mat) {
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(mat);
        LinkedHashMap<String, String> description = new LinkedHashMap<String, String>();
        description.put("tx", String.valueOf(transform.tx));
        description.put("ty", String.valueOf(transform.ty));
        description.put("tz", String.valueOf(transform.tz));
        description.put("sx", String.valueOf(transform.sx));
        description.put("sy", String.valueOf(transform.sy));
        description.put("sz", String.valueOf(transform.sz));
        description.put("yaw", String.valueOf(transform.yaw));
        description.put("pitch", String.valueOf(transform.pitch));
        description.put("roll", String.valueOf(transform.roll));
        double hS = Math.abs((double)(transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        description.put("hS", String.valueOf(hS));
        description.put("hRot", String.valueOf(hRot));
        return description;
    }

    @Override
    public String getName() {
        return "dumprt";
    }

    @Override
    public String getUsage(CommandSourceStack sender) {
        return "/cstickit dumprt - Dumps render type information";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.getName()).requires(source -> source.hasPermission(this.getRequiredPermissionLevel()))).executes(context -> this.execute((CommandSourceStack)context.getSource()));
    }

    private int execute(CommandSourceStack sender) {
        LinkedListMultimap data = LinkedListMultimap.create();
        String[] renderDataHeadersTemp = new String[]{""};
        CommandDumpRenderTypes.getAllStacks().stream().map(ref -> ref.stack).forEachOrdered(arg_0 -> CommandDumpRenderTypes.lambda$execute$9(renderDataHeadersTemp, (Multimap)data, arg_0));
        String renderDataHeaders = renderDataHeadersTemp[0];
        if (data.isEmpty()) {
            sender.sendFailure((Component)Component.literal((String)"No data (open the creative search tab once)"));
            return 0;
        }
        StringBuilder output = new StringBuilder();
        output.append("stacks\t");
        output.append(renderDataHeaders);
        data.keySet().forEach(arg_0 -> CommandDumpRenderTypes.lambda$execute$10(output, (Multimap)data, arg_0));
        LOG.info((CharSequence)output);
        sender.sendSuccess(() -> CommandDumpRenderTypes.lambda$execute$11((Multimap)data), true);
        return 1;
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    private static /* synthetic */ Component lambda$execute$11(Multimap data) {
        return Component.literal((String)("Render Type Data dumped (see logs)\nUnique transforms: " + data.keySet().size() + "\nNum Stacks: " + data.size()));
    }

    private static /* synthetic */ void lambda$execute$10(StringBuilder output, Multimap data, String k) {
        output.append("\n").append(String.join((CharSequence)",", data.get((Object)k))).append("\t").append(k);
    }

    private static /* synthetic */ void lambda$execute$9(String[] renderDataHeadersTemp, Multimap data, ItemStack stack) {
        LinkedHashMap renderData = Stream.concat(Stream.of(new AbstractMap.SimpleEntry<String, String>("renderType", String.valueOf(TESRPlacedItems.getRenderTypeFromStack(stack)))), CommandDumpRenderTypes.getRenderData(stack)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
        if (renderDataHeadersTemp[0].isEmpty()) {
            renderDataHeadersTemp[0] = String.join((CharSequence)"\t", renderData.keySet());
        }
        data.put((Object)String.join((CharSequence)"\t", renderData.values()), (Object)CommandDumpRenderTypes.describeStack(stack));
    }

    private static class ItemStackRef {
        public final ItemStack stack;
        public final DataComponentMap tagsmap;

        public ItemStackRef(Item item) {
            this(new ItemStack((ItemLike)item));
        }

        public ItemStackRef(ItemStack stack) {
            this.stack = stack.copy();
            this.tagsmap = stack.getComponents();
            this.stack.setCount(Math.min(stack.getCount(), 1));
        }

        public int hashCode() {
            int result = this.stack.getItem().hashCode();
            DataComponentMap tag = this.stack.getComponents();
            result = 31 * result + tag.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemStackRef)) {
                return false;
            }
            ItemStackRef o = (ItemStackRef)obj;
            if (this.stack.getItem() != o.stack.getItem()) {
                return false;
            }
            return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)o.stack);
        }
    }
}

