/*
 * Decompiled with CFR 0.152.
 */
package toni.cerulean.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import toni.cerulean.Common;
import toni.cerulean.iface.IItemPredicateMixin;
import toni.cerulean.util.LogHelper;

@Mixin(value={InventoryChangeTrigger.TriggerInstance.class})
abstract class InventoryChangeTriggerInstanceMixin {
    InventoryChangeTriggerInstanceMixin() {
    }

    @Inject(method={"matches(Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/item/ItemStack;III)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;getContainerSize()I", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void matches(Inventory inventory, ItemStack itemStack, int full, int empty, int occupied, CallbackInfoReturnable<Boolean> cir, @Local List<ItemPredicate> predicatesList) {
        if (Common.config.OPTIMIZE_MULTIPLE_PREDICATE_TRIGGER && !predicatesList.removeIf(itemPredicate -> itemPredicate.test(itemStack))) {
            LogHelper.debug("Trigger has multiple predicates, and none of them matches changed item. Skipping full inventory check");
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Redirect(method={"matches(Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/item/ItemStack;III)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/ItemPredicate;test(Lnet/minecraft/world/item/ItemStack;)Z"))
    public boolean itemPredicateMatches(ItemPredicate itemPredicate, ItemStack itemStack) {
        if (Common.config.CHECK_COUNT_BEFORE_ITEM_PREDICATE_MATCH) {
            return ((IItemPredicateMixin)itemPredicate).cerulean$fasterMatches(itemStack);
        }
        return itemPredicate.test(itemStack);
    }
}

