/*
 * Decompiled with CFR 0.152.
 */
package toni.cerulean.impl;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.world.item.ItemStack;
import toni.cerulean.iface.IItemStackMixin;
import toni.cerulean.util.LogHelper;

public class StackSizeThresholdManager {
    private static final SortedSet<Integer> stackSizeThresholds = new TreeSet<Integer>();

    public static void clear() {
        stackSizeThresholds.clear();
        stackSizeThresholds.add(1);
    }

    public static void add(int value) {
        stackSizeThresholds.add(value);
    }

    public static boolean doesStackPassThreshold(ItemStack stack) {
        int prevValue = ((IItemStackMixin)stack).cerulean$getPreviousStackSize();
        int newValue = stack.getCount();
        Iterator iterator = stackSizeThresholds.iterator();
        while (iterator.hasNext()) {
            int thr = (Integer)iterator.next();
            if (prevValue >= thr || newValue < thr) continue;
            return true;
        }
        return false;
    }

    public static void debugPrint() {
        LogHelper.debug(() -> "InventoryChangeTrigger stack size thresholds: %s".formatted(stackSizeThresholds));
    }
}

