/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.network;

import mcjty.rftoolsdim.modules.workbench.client.GuiWorkbench;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketPatternToClient(String[] pattern) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"pattern_to_client");
    public static final CustomPacketPayload.Type<PacketPatternToClient> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketPatternToClient> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeInt(packet.pattern.length);
        for (String p : packet.pattern) {
            buf.writeUtf(p);
        }
    }, buf -> {
        int size = buf.readInt();
        String[] pattern = new String[size];
        for (int i = 0; i < size; ++i) {
            pattern[i] = buf.readUtf(Short.MAX_VALUE);
        }
        return new PacketPatternToClient(pattern);
    });

    public static PacketPatternToClient create(String[] p) {
        return new PacketPatternToClient(p);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> GuiWorkbench.setPattern(this.pattern));
    }
}

