/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import mcjty.rftoolsdim.modules.workbench.blocks.ResearcherTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ResearcherRenderer
implements BlockEntityRenderer<ResearcherTileEntity> {
    public static final ResourceLocation LIGHT = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"block/light");

    public ResearcherRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ResearcherTileEntity te, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IItemHandler handler = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null);
        if (handler != null) {
            matrixStack.pushPose();
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            long millis = System.currentTimeMillis();
            ItemStack stack = handler.getStackInSlot(0);
            if (!stack.isEmpty()) {
                matrixStack.pushPose();
                matrixStack.scale(0.5f, 0.5f, 0.5f);
                matrixStack.translate(1.0f, 2.1f, 1.0f);
                float angle = millis / 45L % 360L;
                RenderHelper.rotateYP((PoseStack)matrixStack, (float)angle);
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, 0xF000F0, combinedOverlay, matrixStack, buffer, (Level)Minecraft.getInstance().level, 0);
                matrixStack.popPose();
                matrixStack.translate(0.0f, 0.5f, 0.0f);
                RenderHelper.renderBillboardQuadBright((PoseStack)matrixStack, (MultiBufferSource)buffer, (float)0.5f, (ResourceLocation)LIGHT, (RenderSettings)RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_ADD).alpha(128).build());
            }
            matrixStack.popPose();
        }
    }

    public static void register() {
        BlockEntityRenderers.register(WorkbenchModule.TYPE_RESEARCHER.get(), ResearcherRenderer::new);
    }
}

