/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsdim.modules.dimlets.client.DimletClientHelper;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import mcjty.rftoolsdim.modules.workbench.blocks.WorkbenchTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiWorkbench
extends GenericGuiContainer<WorkbenchTileEntity, GenericContainer> {
    public static final int WIDTH = 256;
    public static final int HEIGHT = 240;
    private static final ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"textures/gui/dimletworkbench.png");
    private static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbase", (String)"textures/gui/guielements.png");
    private TextField searchBar;
    private WidgetList itemList;
    private ToggleButton allFilter;
    private long dimletListAge = -1L;
    private static String[] pattern = null;

    public GuiWorkbench(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)WorkbenchModule.WORKBENCH.block().get()).getManualEntry());
        this.imageWidth = 256;
        this.imageHeight = 240;
        pattern = null;
    }

    public void init() {
        super.init();
        this.searchBar = Widgets.textfield((int)122, (int)6, (int)123, (int)14).event(this::search);
        this.itemList = ((WidgetList)Widgets.list((int)122, (int)22, (int)120, (int)132).name("widgets")).event(new SelectionEvent(){

            public void select(int index) {
                GuiWorkbench.this.hilightPattern();
            }

            public void doubleClick(int index) {
                if (Minecraft.getInstance().player.getAbilities().instabuild && Screen.hasShiftDown()) {
                    GuiWorkbench.this.cheatDimlet();
                } else {
                    GuiWorkbench.this.suggestParts();
                }
            }
        });
        Slider slider = Widgets.slider((int)243, (int)22, (int)8, (int)132).scrollableName("widgets");
        Button createButton = Widgets.button((int)210, (int)178, (int)40, (int)18, (String)"Create").event(this::createDimlet);
        this.allFilter = ((ToggleButton)((ToggleButton)new ToggleButton().hint(210, 158, 40, 18)).text("All")).event(this::toggleAll);
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.searchBar, this.itemList, slider, createButton, this.allFilter});
        toplevel.bounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.dimletListAge = -1L;
        WorkbenchTileEntity te = (WorkbenchTileEntity)this.getBE();
        if (te != null) {
            Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)te.getBlockPos(), (String)WorkbenchTileEntity.CMD_GETDIMLETS.name()));
        }
    }

    private void createDimlet() {
        this.sendServerCommandTyped(WorkbenchTileEntity.CMD_CREATE_DIMLET, TypedMap.builder().build());
    }

    private void hilightPattern() {
        DimletClientHelper.DimletWithInfo key;
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Panel widget = (Panel)this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletClientHelper.DimletWithInfo && (key = (DimletClientHelper.DimletWithInfo)userObject).craftable()) {
            DimletKey dimlet = key.dimlet();
            this.sendServerCommandTyped(WorkbenchTileEntity.CMD_HILIGHT_PATTERN, TypedMap.builder().put(WorkbenchTileEntity.PARAM_TYPE, (Object)dimlet.type().name()).put(WorkbenchTileEntity.PARAM_ID, (Object)dimlet.key()).build());
        }
    }

    public static void setPattern(String[] pattern) {
        GuiWorkbench.pattern = pattern;
    }

    private void renderHilightedPattern(GuiGraphics graphics) {
        if (pattern != null) {
            Lighting.setupFor3DItems();
            PoseStack matrixStack = graphics.pose();
            matrixStack.pushPose();
            matrixStack.translate((float)this.leftPos, (float)this.topPos, 100.0f);
            GlStateManager._enableDepthTest();
            GlStateManager._disableBlend();
            for (int y = 0; y < pattern.length; ++y) {
                String p = pattern[y];
                for (int x = 0; x < p.length(); ++x) {
                    int slotIdx;
                    Slot slot;
                    ItemStack stack = KnowledgeManager.getPatternItem(p.charAt(x));
                    if (stack.isEmpty() || (slot = ((GenericContainer)this.menu).getSlot(slotIdx = 5 + y * pattern.length + x)).hasItem()) continue;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                    graphics.renderItem(stack, slot.x, slot.y);
                    graphics.renderItemDecorations(this.font, stack, slot.x, slot.y);
                    RenderSystem.enableBlend();
                    RenderSystem.disableDepthTest();
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconGuiElements);
                    RenderHelper.drawTexturedModalRect((PoseStack)matrixStack, (int)slot.x, (int)slot.y, (int)224, (int)48, (int)16, (int)16);
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableBlend();
                }
            }
            matrixStack.popPose();
        }
    }

    private void cheatDimlet() {
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Panel widget = (Panel)this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletClientHelper.DimletWithInfo) {
            DimletClientHelper.DimletWithInfo key = (DimletClientHelper.DimletWithInfo)userObject;
            DimletKey dimlet = key.dimlet();
            this.sendServerCommandTyped(WorkbenchTileEntity.CMD_CHEATDIMLET, TypedMap.builder().put(WorkbenchTileEntity.PARAM_TYPE, (Object)dimlet.type().name()).put(WorkbenchTileEntity.PARAM_ID, (Object)dimlet.key()).build());
        }
    }

    private void suggestParts() {
        DimletClientHelper.DimletWithInfo key;
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Panel widget = (Panel)this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletClientHelper.DimletWithInfo && (key = (DimletClientHelper.DimletWithInfo)userObject).craftable()) {
            DimletKey dimlet = key.dimlet();
            this.sendServerCommandTyped(WorkbenchTileEntity.CMD_SUGGESTPARTS, TypedMap.builder().put(WorkbenchTileEntity.PARAM_TYPE, (Object)dimlet.type().name()).put(WorkbenchTileEntity.PARAM_ID, (Object)dimlet.key()).build());
        }
    }

    private void toggleAll() {
        this.dimletListAge = -1L;
    }

    private void search(String filter) {
        this.dimletListAge = -1L;
    }

    private void updateList() {
        if (this.dimletListAge == DimletClientHelper.dimletListAge) {
            return;
        }
        this.dimletListAge = DimletClientHelper.dimletListAge;
        this.itemList.removeChildren();
        String filter = this.searchBar.getText().toLowerCase();
        DimletClientHelper.dimlets.stream().filter(key -> this.dimletMatches(filter, (DimletClientHelper.DimletWithInfo)key)).sorted().forEachOrdered(this::addItemToList);
        if (this.itemList.getFirstSelected() >= this.itemList.getChildCount()) {
            this.itemList.setFirstSelected(0);
        }
    }

    private boolean dimletMatches(String filter, DimletClientHelper.DimletWithInfo key) {
        if (this.allFilter.isPressed() || key.craftable()) {
            DimletKey dimlet = key.dimlet();
            String readableName = DimletTools.getReadableName(dimlet);
            return readableName.toLowerCase().contains(filter) || dimlet.type().name().toLowerCase().contains(filter);
        }
        return false;
    }

    private void addItemToList(DimletClientHelper.DimletWithInfo key) {
        Panel panel = (Panel)((Panel)((Panel)Widgets.positional().desiredWidth(113)).desiredHeight(16)).userObject((Object)key);
        this.itemList.children(new Widget[]{panel});
        BlockRender blockRender = (BlockRender)((BlockRender)new BlockRender().renderItem((Object)DimletTools.getDimletStack(key.dimlet())).hint(1, 0, 16, 16)).userObject((Object)key);
        panel.children(new Widget[]{blockRender});
        String displayName = DimletTools.getReadableName(key.dimlet());
        AbstractWidget label = ((Label)((Label)((Label)Widgets.label((String)displayName).color(key.craftable() ? StyleConfig.colorTextInListNormal : StyleConfig.colorTextDisabled)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(20, 0, 95, 16)).userObject((Object)key);
        panel.children(new Widget[]{label});
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.updateList();
        this.drawWindow(graphics, partialTicks, x, y);
        this.renderHilightedPattern(graphics);
    }
}

