/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.knowledge.KnowledgeModule;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.modules.knowledge.data.LostKnowledgeData;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class LostKnowledgeItem
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"pattern", this::getPatternString), TooltipBuilder.parameter((String)"reason", s -> this.getReasonString((ItemStack)s) != null, this::getReasonString)}));
    private final DimletRarity rarity;

    private String getReasonString(ItemStack stack) {
        LostKnowledgeData data = (LostKnowledgeData)stack.get(KnowledgeModule.ITEM_LOST_KNOWLEDGE_DATA);
        if (data != null) {
            return data.reason();
        }
        return null;
    }

    private String getPatternString(ItemStack stack) {
        LostKnowledgeData data = (LostKnowledgeData)stack.get(KnowledgeModule.ITEM_LOST_KNOWLEDGE_DATA);
        if (data != null) {
            String pattern = data.pattern();
            KnowledgeKey kkey = KnowledgeKey.create(pattern);
            return kkey.rarity().name().toLowerCase() + " " + kkey.type().name().toLowerCase();
        }
        return "<Unknown>";
    }

    public LostKnowledgeItem(DimletRarity rarity) {
        super(Registration.createStandardProperties());
        this.rarity = rarity;
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    @Nullable
    public static KnowledgeKey getKnowledgeKey(ItemStack stack) {
        LostKnowledgeData data = (LostKnowledgeData)stack.get(KnowledgeModule.ITEM_LOST_KNOWLEDGE_DATA);
        if (data != null) {
            String pattern = data.pattern();
            return KnowledgeKey.create(pattern);
        }
        return null;
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.appendHoverText(itemStack, context, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flags);
    }

    public static ItemStack createUnresearchedLostKnowledge(DimletRarity rarity) {
        return switch (rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> new ItemStack((ItemLike)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get());
            case DimletRarity.UNCOMMON -> new ItemStack((ItemLike)KnowledgeModule.UNCOMMON_LOST_KNOWLEDGE.get());
            case DimletRarity.RARE -> new ItemStack((ItemLike)KnowledgeModule.RARE_LOST_KNOWLEDGE.get());
            case DimletRarity.LEGENDARY -> new ItemStack((ItemLike)KnowledgeModule.LEGENDARY_LOST_KNOWLEDGE.get());
        };
    }

    public static ItemStack createLostKnowledge(Level world, DimletKey key) {
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null) {
            ServerLevel overworld = LevelTools.getOverworld((Level)world);
            KnowledgeKey kkey = KnowledgeManager.get().getKnowledgeKey((CommonLevelAccessor)overworld, overworld.getSeed(), key);
            if (kkey != null) {
                DimletRarity rarity = settings.getRarity();
                return LostKnowledgeItem.createLostKnowledgeStack(world, rarity, kkey);
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack createRandomLostKnowledge(Level world, DimletRarity rarity, RandomSource random) {
        List<KnowledgeKey> patterns = KnowledgeManager.get().getKnownPatterns(world, rarity);
        if (patterns.isEmpty()) {
            return ItemStack.EMPTY;
        }
        KnowledgeKey kkey = patterns.get(random.nextInt(patterns.size()));
        return LostKnowledgeItem.createLostKnowledgeStack(world, rarity, kkey);
    }

    private static ItemStack createLostKnowledgeStack(Level world, DimletRarity rarity, KnowledgeKey kkey) {
        LostKnowledgeItem item = LostKnowledgeItem.getKnowledgeItem(rarity);
        ItemStack result = new ItemStack((ItemLike)item);
        String reason = KnowledgeManager.get().getReason(world, kkey);
        result.set(KnowledgeModule.ITEM_LOST_KNOWLEDGE_DATA, (Object)new LostKnowledgeData(kkey.serialize(), reason));
        return result;
    }

    private static LostKnowledgeItem getKnowledgeItem(DimletRarity rarity) {
        KnowledgeModule.COMMON_LOST_KNOWLEDGE.get();
        return switch (rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> (LostKnowledgeItem)((Object)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get());
            case DimletRarity.UNCOMMON -> (LostKnowledgeItem)((Object)KnowledgeModule.UNCOMMON_LOST_KNOWLEDGE.get());
            case DimletRarity.RARE -> (LostKnowledgeItem)((Object)KnowledgeModule.RARE_LOST_KNOWLEDGE.get());
            case DimletRarity.LEGENDARY -> (LostKnowledgeItem)((Object)KnowledgeModule.LEGENDARY_LOST_KNOWLEDGE.get());
        };
    }
}

