/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.data.StructureAbsorberData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureAbsorberTileEntity
extends TickingTileEntity {
    public StructureAbsorberTileEntity(BlockPos pos, BlockState state) {
        super(EssencesModule.TYPE_STRUCTURE_ABSORBER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).noOcclusion()).tileEntitySupplier(StructureAbsorberTileEntity::new).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:dimlets/dimlet_workbench")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"block", StructureAbsorberTileEntity::getStructureName), TooltipBuilder.parameter((String)"progress", StructureAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getStructureName(ItemStack stack) {
        StructureAbsorberData data = (StructureAbsorberData)stack.get(EssencesModule.ITEM_STRUCTURE_ABSORBER_DATA);
        if (data == null || data.structure() == null) {
            return "<Not Set>";
        }
        return I18n.get((String)data.structure().toLanguageKey(Registries.STRUCTURE.location().getPath()).replace('/', '.'), (Object[])new Object[0]);
    }

    public static ResourceLocation getStructure(ItemStack stack) {
        StructureAbsorberData data = (StructureAbsorberData)stack.getOrDefault(EssencesModule.ITEM_STRUCTURE_ABSORBER_DATA, (Object)StructureAbsorberData.DEFAULT);
        return data.structure();
    }

    private static String getProgressName(ItemStack stack) {
        StructureAbsorberData data = (StructureAbsorberData)stack.get(EssencesModule.ITEM_STRUCTURE_ABSORBER_DATA);
        if (data == null) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxStructureAbsorption.get() - data.absorbing()) * 100 / (Integer)EssencesConfig.maxStructureAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        StructureAbsorberData data = (StructureAbsorberData)stack.get(EssencesModule.ITEM_STRUCTURE_ABSORBER_DATA);
        if (data == null) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxStructureAbsorption.get() - data.absorbing()) * 100 / (Integer)EssencesConfig.maxStructureAbsorption.get();
    }

    protected void tickClient() {
        StructureAbsorberData data = (StructureAbsorberData)this.getData(EssencesModule.STRUCTURE_ABSORBER_DATA);
        if (data.absorbing() > 0) {
            RandomSource rand = this.level.random;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)this.getBlockPos().getX() + 0.5f) + x * r, (double)((float)this.getBlockPos().getY() + 0.5f) + y * r, (double)((float)this.getBlockPos().getZ() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    public int getAbsorbing() {
        StructureAbsorberData data = (StructureAbsorberData)this.getData(EssencesModule.STRUCTURE_ABSORBER_DATA);
        return data.absorbing();
    }

    public ResourceLocation getAbsorbingStructure() {
        StructureAbsorberData data = (StructureAbsorberData)this.getData(EssencesModule.STRUCTURE_ABSORBER_DATA);
        return data.structure();
    }

    protected void tickServer() {
        StructureAbsorberData data = (StructureAbsorberData)this.getData(EssencesModule.STRUCTURE_ABSORBER_DATA);
        ResourceLocation structureId = data.structure();
        int absorbing = data.absorbing();
        if (structureId == null) {
            ChunkPos cp = new ChunkPos(this.worldPosition);
            Map references = this.level.getChunk(cp.x, cp.z).getAllReferences();
            ArrayList<ResourceLocation> structures = new ArrayList<ResourceLocation>();
            for (Map.Entry entry : references.entrySet()) {
                if (((LongSet)entry.getValue()).isEmpty()) continue;
                structures.add(Tools.getId((CommonLevelAccessor)this.level, (Structure)((Structure)entry.getKey())));
            }
            if (!structures.isEmpty()) {
                structureId = structures.size() == 1 ? (ResourceLocation)structures.get(0) : (ResourceLocation)structures.get(this.level.random.nextInt(structures.size()));
                absorbing = (Integer)EssencesConfig.maxStructureAbsorption.get();
            }
        }
        if (absorbing > 0) {
            if (!this.isValidStructure()) {
                return;
            }
            --absorbing;
        }
        this.setData(EssencesModule.STRUCTURE_ABSORBER_DATA, new StructureAbsorberData(structureId, absorbing));
    }

    private boolean isValidStructure() {
        StructureAbsorberData data = (StructureAbsorberData)this.getData(EssencesModule.STRUCTURE_ABSORBER_DATA);
        ChunkPos cp = new ChunkPos(this.worldPosition);
        Map references = this.level.getChunk(cp.x, cp.z).getAllReferences();
        for (Map.Entry entry : references.entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty() || !Objects.equals(data.structure(), Tools.getId((CommonLevelAccessor)this.level, (Structure)((Structure)entry.getKey())).toString())) continue;
            return true;
        }
        return false;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        StructureAbsorberData data = (StructureAbsorberData)input.get(EssencesModule.ITEM_STRUCTURE_ABSORBER_DATA);
        if (data != null) {
            this.setData(EssencesModule.STRUCTURE_ABSORBER_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        StructureAbsorberData data = (StructureAbsorberData)this.getData(EssencesModule.STRUCTURE_ABSORBER_DATA);
        builder.set((DataComponentType)EssencesModule.ITEM_STRUCTURE_ABSORBER_DATA.get(), (Object)data);
    }
}

