/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.data.BlockFluidAbsorberData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FluidAbsorberTileEntity
extends TickingTileEntity {
    private static final int ABSORB_SPEED = 2;
    private int timer = 2;
    private final Set<BlockPos> toscan = new HashSet<BlockPos>();
    private final FakePlayerGetter harvester = new FakePlayerGetter((GenericTileEntity)this, "rftools_fluid_absorber");

    public FluidAbsorberTileEntity(BlockPos pos, BlockState state) {
        super(EssencesModule.TYPE_FLUID_ABSORBER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).noOcclusion()).tileEntitySupplier(FluidAbsorberTileEntity::new).manualEntry(ManualHelper.create((String)"rftoolsbase:dimlets/dimlet_workbench")).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"fluid", FluidAbsorberTileEntity::getFluidName), TooltipBuilder.parameter((String)"progress", FluidAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getFluidName(ItemStack stack) {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)stack.get(EssencesModule.ITEM_BLOCKFLUID_ABSORBER_DATA);
        if (data == null || data.block() == null) {
            return "<Not Set>";
        }
        return I18n.get((String)data.block().toLanguageKey(Registries.FLUID.location().getPath()).replace('/', '.'), (Object[])new Object[0]);
    }

    public static ResourceLocation getFluid(ItemStack stack) {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)stack.getOrDefault(EssencesModule.ITEM_BLOCKFLUID_ABSORBER_DATA, (Object)BlockFluidAbsorberData.DEFAULT);
        return data.block();
    }

    private static String getProgressName(ItemStack stack) {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)stack.get(EssencesModule.ITEM_BLOCKFLUID_ABSORBER_DATA);
        if (data == null) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxFluidAbsorption.get() - data.absorbing()) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)stack.get(EssencesModule.ITEM_BLOCKFLUID_ABSORBER_DATA);
        if (data == null) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxFluidAbsorption.get() - data.absorbing()) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
    }

    protected void tickServer() {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        ResourceLocation blockId = data.block();
        int absorbing = data.absorbing();
        if (absorbing > 0 || blockId == null) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 2;
                BlockState b = this.isValidSourceBlock(this.getBlockPos().below());
                if (b != null) {
                    if (blockId == null) {
                        absorbing = (Integer)EssencesConfig.maxFluidAbsorption.get();
                        blockId = Tools.getId((Block)b.getBlock());
                        this.toscan.clear();
                    }
                    this.toscan.add(this.getBlockPos().below());
                }
                if (!this.toscan.isEmpty()) {
                    int r = this.level.random.nextInt(this.toscan.size());
                    Iterator<BlockPos> iterator = this.toscan.iterator();
                    BlockPos c = null;
                    for (int i = 0; i <= r; ++i) {
                        c = iterator.next();
                    }
                    this.toscan.remove(c);
                    this.checkBlock(c, Direction.DOWN);
                    this.checkBlock(c, Direction.UP);
                    this.checkBlock(c, Direction.EAST);
                    this.checkBlock(c, Direction.WEST);
                    this.checkBlock(c, Direction.SOUTH);
                    this.checkBlock(c, Direction.NORTH);
                    if (this.blockMatches(c)) {
                        BlockState oldState = this.level.getBlockState(c);
                        FluidState oldFluidState = this.level.getFluidState(c);
                        SoundTools.playSound((Level)this.level, (SoundEvent)oldState.getBlock().getSoundType(oldFluidState.createLegacyBlock(), (LevelReader)this.level, c, null).getBreakSound(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (double)1.0, (double)1.0);
                        BlockPos finalC = c;
                        FluidTools.pickupFluidBlock((Level)this.level, (BlockPos)c, s -> true, () -> this.level.setBlock(finalC, Blocks.AIR.defaultBlockState(), 2));
                        --absorbing;
                        BlockState newState = this.level.getBlockState(c);
                        this.level.sendBlockUpdated(c, oldState, newState, 3);
                    }
                }
            }
            this.setData(EssencesModule.BLOCKFLUID_ABSORBER_DATA, new BlockFluidAbsorberData(blockId, absorbing));
        }
    }

    protected void tickClient() {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        if (data.absorbing() > 0) {
            RandomSource rand = this.level.random;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)this.getBlockPos().getX() + 0.5f) + x * r, (double)((float)this.getBlockPos().getY() + 0.5f) + y * r, (double)((float)this.getBlockPos().getZ() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    private void checkBlock(BlockPos c, Direction direction) {
        BlockPos c2 = c.relative(direction);
        if (this.blockMatches(c2)) {
            this.toscan.add(c2);
        }
    }

    private boolean blockMatches(BlockPos c) {
        FluidState state = this.level.getFluidState(c);
        if (!state.isSource()) {
            return false;
        }
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        return Objects.equals(Tools.getId((Block)this.level.getBlockState(c).getBlock()), data.block());
    }

    public int getAbsorbing() {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        return data.absorbing();
    }

    @Nullable
    public ResourceLocation getAbsorbingBlock() {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        return data.block();
    }

    public Fluid getAbsorbingFluid() {
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        if (data.block() != null) {
            return Tools.getFluid((ResourceLocation)data.block());
        }
        return null;
    }

    private BlockState isValidSourceBlock(BlockPos coordinate) {
        if (!BlockAbsorberTileEntity.allowedToBreak(this.level.getBlockState(coordinate), this.level, coordinate, (Player)this.harvester.get())) {
            return null;
        }
        FluidState state = this.level.getFluidState(coordinate);
        if (this.isValidDimletFluid(state)) {
            return state.createLegacyBlock();
        }
        return null;
    }

    private boolean isValidDimletFluid(FluidState fluidState) {
        if (fluidState != null && !fluidState.isEmpty()) {
            if (!fluidState.isSource()) {
                return false;
            }
            Fluid fluid = fluidState.getType();
            DimletKey key = new DimletKey(DimletType.FLUID, Tools.getId((Fluid)fluid).toString());
            DimletSettings settings = DimletDictionary.get().getSettings(key);
            return settings != null && settings.isDimlet();
        }
        return false;
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        int[] x = tagCompound.getIntArray("toscanx");
        int[] y = tagCompound.getIntArray("toscany");
        int[] z = tagCompound.getIntArray("toscanz");
        this.toscan.clear();
        for (int i = 0; i < x.length; ++i) {
            this.toscan.add(new BlockPos(x[i], y[i], z[i]));
        }
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        int[] x = new int[this.toscan.size()];
        int[] y = new int[this.toscan.size()];
        int[] z = new int[this.toscan.size()];
        int i = 0;
        for (BlockPos c : this.toscan) {
            x[i] = c.getX();
            y[i] = c.getY();
            z[i] = c.getZ();
            ++i;
        }
        tagCompound.putIntArray("toscanx", x);
        tagCompound.putIntArray("toscany", y);
        tagCompound.putIntArray("toscanz", z);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)input.get(EssencesModule.ITEM_BLOCKFLUID_ABSORBER_DATA);
        if (data != null) {
            this.setData(EssencesModule.BLOCKFLUID_ABSORBER_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        BlockFluidAbsorberData data = (BlockFluidAbsorberData)this.getData(EssencesModule.BLOCKFLUID_ABSORBER_DATA);
        builder.set((DataComponentType)EssencesModule.ITEM_BLOCKFLUID_ABSORBER_DATA.get(), (Object)data);
    }
}

