/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.data.BiomeAbsorberData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BiomeAbsorberTileEntity
extends TickingTileEntity {
    public BiomeAbsorberTileEntity(BlockPos pos, BlockState state) {
        super(EssencesModule.TYPE_BIOME_ABSORBER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).noOcclusion()).tileEntitySupplier(BiomeAbsorberTileEntity::new).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:dimlets/dimlet_workbench")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"block", BiomeAbsorberTileEntity::getBiomeName), TooltipBuilder.parameter((String)"progress", BiomeAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getBiomeName(ItemStack stack) {
        BiomeAbsorberData data = (BiomeAbsorberData)stack.get(EssencesModule.ITEM_BIOME_ABSORBER_DATA);
        if (data == null || data.biome() == null) {
            return "<Not Set>";
        }
        return I18n.get((String)data.biome().toLanguageKey(Registries.BIOME.location().getPath()).replace('/', '.'), (Object[])new Object[0]);
    }

    public static ResourceLocation getBiome(ItemStack stack) {
        BiomeAbsorberData data = (BiomeAbsorberData)stack.getOrDefault(EssencesModule.ITEM_BIOME_ABSORBER_DATA, (Object)BiomeAbsorberData.DEFAULT);
        return data.biome();
    }

    private static String getProgressName(ItemStack stack) {
        BiomeAbsorberData data = (BiomeAbsorberData)stack.get(EssencesModule.ITEM_BIOME_ABSORBER_DATA);
        if (data == null) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxBiomeAbsorption.get() - data.absorbing()) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        BiomeAbsorberData data = (BiomeAbsorberData)stack.get(EssencesModule.ITEM_BIOME_ABSORBER_DATA);
        if (data == null) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxBiomeAbsorption.get() - data.absorbing()) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
    }

    protected void tickClient() {
        BiomeAbsorberData data = (BiomeAbsorberData)this.getData(EssencesModule.BIOME_ABSORBER_DATA);
        if (data.absorbing() > 0) {
            RandomSource rand = this.level.random;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)this.getBlockPos().getX() + 0.5f) + x * r, (double)((float)this.getBlockPos().getY() + 0.5f) + y * r, (double)((float)this.getBlockPos().getZ() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    public int getAbsorbing() {
        BiomeAbsorberData data = (BiomeAbsorberData)this.getData(EssencesModule.BIOME_ABSORBER_DATA);
        return data.absorbing();
    }

    @Nullable
    public ResourceLocation getAbsorbingBiome() {
        BiomeAbsorberData data = (BiomeAbsorberData)this.getData(EssencesModule.BIOME_ABSORBER_DATA);
        return data.biome();
    }

    protected void tickServer() {
        Holder biome;
        BiomeAbsorberData data = (BiomeAbsorberData)this.getData(EssencesModule.BIOME_ABSORBER_DATA);
        ResourceLocation biomeId = data.biome();
        int absorbing = data.absorbing();
        if (biomeId == null) {
            biome = this.getLevel().getBiome(this.getBlockPos());
            biomeId = Tools.getId((CommonLevelAccessor)this.level, (Biome)((Biome)biome.value()));
            absorbing = (Integer)EssencesConfig.maxBiomeAbsorption.get();
        }
        if (absorbing > 0) {
            biome = this.level.getBiome(this.worldPosition);
            if (!Tools.getId((CommonLevelAccessor)this.level, (Biome)((Biome)biome.value())).equals((Object)biomeId)) {
                return;
            }
            --absorbing;
        }
        this.setData(EssencesModule.BIOME_ABSORBER_DATA, new BiomeAbsorberData(biomeId, absorbing));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        BiomeAbsorberData data = (BiomeAbsorberData)input.get(EssencesModule.ITEM_BIOME_ABSORBER_DATA);
        if (data != null) {
            this.setData(EssencesModule.BIOME_ABSORBER_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        BiomeAbsorberData data = (BiomeAbsorberData)this.getData(EssencesModule.BIOME_ABSORBER_DATA);
        builder.set((DataComponentType)EssencesModule.ITEM_BIOME_ABSORBER_DATA.get(), (Object)data);
    }
}

