/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.enscriber.client;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.enscriber.EnscriberModule;
import mcjty.rftoolsdim.modules.enscriber.blocks.EnscriberTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiEnscriber
extends GenericGuiContainer<EnscriberTileEntity, GenericContainer> {
    public static final int ENSCRIBER_WIDTH = 256;
    public static final int ENSCRIBER_HEIGHT = 224;
    public static final String REGEX = "[a-z0-9_\\.\\-]+";
    private Button extractButton;
    private Button storeButton;
    private TextField nameField;
    private Label validateField;
    private static final ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"textures/gui/dimensionenscriber.png");

    public GuiEnscriber(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)EnscriberModule.ENSCRIBER.block().get()).getManualEntry());
        this.imageWidth = 256;
        this.imageHeight = 224;
    }

    public void init() {
        super.init();
        this.extractButton = (Button)((Button)Widgets.button((int)12, (int)164, (int)60, (int)16, (String)"Extract").name("extract")).event(this::extractDimlets).tooltips(new String[]{"Extract the dimlets out of", "a realized dimension tab"});
        this.storeButton = (Button)Widgets.button((int)13, (int)182, (int)60, (int)16, (String)"Store").event(this::storeDimlets).tooltips(new String[]{"Store dimlets in a", "empty dimension tab"});
        this.nameField = (TextField)Widgets.textfield((int)13, (int)200, (int)60, (int)16).name("name");
        this.validateField = (Label)Widgets.label((int)35, (int)142, (int)38, (int)16, (String)"Val").tooltips(new String[]{"Hover here for errors..."});
        this.setNameFromDimensionTab();
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.extractButton, this.storeButton, this.nameField, this.validateField});
        toplevel.bounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void extractDimlets() {
        for (int i = 0; i < 91; ++i) {
            ItemStack stack = ((Slot)((GenericContainer)this.menu).slots.get(i + 0)).getItem();
            if (stack.isEmpty()) continue;
            Logging.warn((Player)this.minecraft.player, (String)"You cannot extract. Remove all dimlets first!");
            return;
        }
        this.sendServerCommandTyped(EnscriberTileEntity.CMD_EXTRACT, TypedMap.EMPTY);
    }

    private void storeDimlets() {
        String name = this.nameField.getText();
        if (name == null || name.trim().isEmpty()) {
            Minecraft.getInstance().player.displayClientMessage((Component)ComponentFactory.literal((String)"Name is required!"), false);
            return;
        }
        this.sendServerCommandTyped(EnscriberTileEntity.CMD_STORE, TypedMap.builder().put(EnscriberTileEntity.PARAM_NAME, (Object)name).build());
    }

    private void enableButtons() {
        Slot slot = (Slot)((GenericContainer)this.menu).slots.get(91);
        this.extractButton.enabled(false);
        this.storeButton.enabled(false);
        if (!slot.getItem().isEmpty()) {
            if (slot.getItem().getItem() == DimensionBuilderModule.EMPTY_DIMENSION_TAB.get()) {
                this.storeButton.enabled(true);
            } else if (slot.getItem().getItem() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get()) {
                this.extractButton.enabled(true);
            }
        }
    }

    private void validateDimlets() {
        EnscriberTileEntity te = (EnscriberTileEntity)this.getBE();
        if (te == null) {
            this.validateField.text("");
            return;
        }
        int errorCode = te.getClientErrorCode();
        DescriptorError.Code error = DescriptorError.Code.values()[errorCode];
        ArrayList<String> tooltips = new ArrayList<String>();
        if (error == DescriptorError.Code.OK) {
            tooltips.add("Everything appears to be alright");
            this.validateField.color(34816);
            this.validateField.text("Ok");
        } else {
            tooltips.add(error.getMessage());
            this.validateField.color(0xFF0000);
            this.validateField.text("Error");
            this.storeButton.enabled(false);
        }
        this.validateField.tooltips(tooltips.toArray(new String[tooltips.size()]));
    }

    private boolean validateName(String name) {
        if (name.trim().isEmpty()) {
            return false;
        }
        return Pattern.matches(REGEX, name);
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.enableButtons();
        this.validateDimlets();
        String name = this.nameField.getText().trim();
        if (name.isEmpty()) {
            this.storeButton.enabled(false);
            this.storeButton.tooltips(new String[]{"A dimension name is needed!"});
        } else if (!this.validateName(name)) {
            this.storeButton.enabled(false);
            this.storeButton.tooltips(new String[]{"The dimension name is invalid (only lowercase, no special characters)!"});
        } else {
            this.storeButton.tooltips(new String[]{"Store dimlets in a", "empty dimension tab"});
        }
        this.setNameFromDimensionTab();
        this.drawWindow(graphics, partialTicks, x, y);
    }

    private void setNameFromDimensionTab() {
        String dimensionName;
        EnscriberTileEntity te = (EnscriberTileEntity)this.getBE();
        if (te != null && (dimensionName = te.getDimensionName()) != null) {
            this.nameField.text(dimensionName);
        }
    }
}

