/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.lib.crafting.AbstractRecipeAdaptor;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.dimlets.recipes.DimletRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class DimletRecipeSerializer
implements RecipeSerializer<DimletRecipe> {
    private static final Codec<DimletType> DIMLET_TYPE_CODEC = Codec.STRING.xmap(DimletType::byName, Enum::name);
    public static final MapCodec<DimletRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipe.Serializer.CODEC.forGetter(AbstractRecipeAdaptor::getRecipe), (App)DIMLET_TYPE_CODEC.fieldOf("dimlettype").forGetter(recipe -> recipe.getKey().type()), (App)Codec.STRING.fieldOf("dimletkey").forGetter(recipe -> recipe.getKey().key())).apply((Applicative)instance, (shaped, type, key) -> new DimletRecipe((ShapedRecipe)shaped, new DimletKey((DimletType)((Object)((Object)type)), (String)key))));
    public static final StreamCodec<RegistryFriendlyByteBuf, DimletRecipe> STREAM_CODEC = StreamCodec.of((buffer, recipe) -> {
        ShapedRecipe.Serializer.STREAM_CODEC.encode(buffer, (Object)recipe.getRecipe());
        buffer.writeUtf(recipe.getKey().type().name());
        buffer.writeUtf(recipe.getKey().key());
    }, buffer -> {
        ShapedRecipe shaped = (ShapedRecipe)ShapedRecipe.Serializer.STREAM_CODEC.decode(buffer);
        DimletType type = DimletType.byName(buffer.readUtf(Short.MAX_VALUE));
        String key = buffer.readUtf(Short.MAX_VALUE);
        return new DimletRecipe(shaped, new DimletKey(type, key));
    });

    public MapCodec<DimletRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, DimletRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

