/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSendDimletPackages(Map<DimletKey, DimletSettings> dimlets) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"senddimletpackages");
    public static final CustomPacketPayload.Type<PacketSendDimletPackages> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSendDimletPackages> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeInt(packet.dimlets.size());
        for (Map.Entry<DimletKey, DimletSettings> entry : packet.dimlets.entrySet()) {
            entry.getKey().toBytes((FriendlyByteBuf)buf);
            entry.getValue().toBytes((RegistryFriendlyByteBuf)buf);
        }
    }, buf -> {
        int size = buf.readInt();
        HashMap<DimletKey, DimletSettings> dimlets = new HashMap<DimletKey, DimletSettings>(size);
        for (int i = 0; i < size; ++i) {
            DimletKey key = DimletKey.create((FriendlyByteBuf)buf);
            DimletSettings settings = new DimletSettings((RegistryFriendlyByteBuf)buf);
            dimlets.put(key, settings);
        }
        return new PacketSendDimletPackages(dimlets);
    });

    public PacketSendDimletPackages(Map<DimletKey, DimletSettings> dimlets) {
        this.dimlets = new HashMap<DimletKey, DimletSettings>(dimlets);
    }

    public static PacketSendDimletPackages create(Map<DimletKey, DimletSettings> collected) {
        return new PacketSendDimletPackages(collected);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            RegistryAccess access = SafeClientTools.getClientWorld().registryAccess();
            DimletDictionary dictionary = DimletDictionary.get();
            for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
                dictionary.register(access, entry.getKey(), entry.getValue());
            }
        });
    }
}

