/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.lootmodifier;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record LootTableCondition(Set<ResourceLocation> tables) implements LootItemCondition
{
    public static final MapCodec<LootTableCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.listOf().fieldOf("tables").forGetter(condition -> List.copyOf(condition.tables))).apply((Applicative)instance, list -> new LootTableCondition((Set<ResourceLocation>)ImmutableSet.copyOf((Collection)list))));

    public LootItemConditionType getType() {
        return DimletModule.LOOT_TABLE_CONDITION.get();
    }

    public boolean test(LootContext lootContext) {
        ResourceLocation table = lootContext.getQueriedLootTableId();
        return this.tables.contains(table);
    }
}

